/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonalSpaceChanger
extends BasicContentChanger {
    private static final String NAME = "removePersonalSpace";
    public static final String GROUP = "common";
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public PersonalSpaceChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, SpaceManager spaceManager, TransactionTemplate transactionTemplate) {
        super(pluginSettingsFactory, transactionTemplate);
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public boolean isAffected(EntityObject issue, ConfluenceUser user) {
        try {
            Space space = this.spaceManager.getPersonalSpace(user);
            return space != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getAffectedContent(EntityObject issue, ConfluenceUser user) {
        if (this.isAffected(issue, user)) {
            return this.spaceManager.getPersonalSpace(user).getKey();
        }
        return "";
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Removing personal space creator...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        try {
            if (this.isAffected(issue, sourceUser)) {
                Space personalSpace = this.spaceManager.getPersonalSpace(sourceUser);
                changesTotal = changesTotal + personalSpace.getKey() + ", ";
                this.setJobMessage(currentJobId, "Removing personal space " + personalSpace.getKey());
                if (personalSpace != null) {
                    changesSuccess = changesSuccess + personalSpace.getKey();
                    this.spaceManager.removeSpace(personalSpace);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            changesFail = changesFail + "~" + sourceUser.getName();
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    @Override
    public String getChangerGroup() {
        return GROUP;
    }
}

