/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.UserAnonymizerChangerManager;
import de.actonic.confluence.gdpr.component.service.PageService;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerService {
    private static final Logger log = LoggerFactory.getLogger(UserAnonymizerService.class);
    private static final String USER_ANONYMIZATION_EVENT = "USER_ANONYMIZATION_EVENT";
    private static final String TASK_KEY = "task-key";
    @ComponentImport
    private final UserAccessor userAccessor;
    private final UserAnonymizerChangerManager userAnonymizerChangerManager;
    @ComponentImport
    private final CacheManager cacheManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final PluginSettings pluginSettings;
    private final PageService pageService;

    public UserAnonymizerService(UserAccessor userAccessor, UserAnonymizerChangerManager userAnonymizerChangerManager, CacheManager cacheManager, EventPublisher eventPublisher, PluginSettingsFactory pluginSettingsFactory, PageService pageService) {
        this.userAccessor = userAccessor;
        this.userAnonymizerChangerManager = userAnonymizerChangerManager;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.component.service.NewUserAnonymizerService");
        this.pageService = pageService;
    }

    public String runGlobalChanges(Map<String, String> configurationMap) {
        StringBuilder historyMessage = new StringBuilder();
        String userName = configurationMap.get("userName");
        ConfluenceUser sourceUser = this.userAccessor.getUserByName(userName);
        String target = configurationMap.get("target");
        ConfluenceUser targetUser = this.userAccessor.getUserByName(target);
        for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
            boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
            if (!this.userAnonymizerChangerManager.hasGlobalChanger(entry.getKey()) || !valueIsTrue) continue;
            GlobalContentChanger changer = this.userAnonymizerChangerManager.getGlobalChanger(entry.getKey());
            ContentChangerResult contentChangerResult = changer.changeIssues("actonic-gdpr-user-anonymizer-global-changes", sourceUser);
            historyMessage.append(contentChangerResult.getSuccessfullyChanged());
            if (Strings.isNullOrEmpty((String)contentChangerResult.getBadlyChanged())) continue;
            historyMessage.append(contentChangerResult.getBadlyChanged());
        }
        if (Boolean.parseBoolean(configurationMap.get("disable"))) {
            this.userAccessor.deactivateUser((User)sourceUser);
            historyMessage.append("User successfully disabled\n");
        }
        if (Boolean.parseBoolean(configurationMap.get("event"))) {
            Properties payload = new Properties();
            payload.setProperty("emitter", USER_ANONYMIZATION_EVENT);
            if (sourceUser != null) {
                payload.setProperty("sourceUsername", sourceUser.getName());
                payload.setProperty("sourceDisplayName", sourceUser.getFullName());
                payload.setProperty("sourceKey", sourceUser.getKey().getStringValue());
                payload.setProperty("sourceEmail", sourceUser.getEmail());
            }
            if (targetUser != null) {
                payload.setProperty("targetUsername", targetUser.getName());
                payload.setProperty("targetDisplayName", targetUser.getFullName());
                payload.setProperty("targetKey", targetUser.getKey().getStringValue());
                payload.setProperty("targetEmail", targetUser.getEmail());
            }
            this.eventPublisher.publish((Object)payload);
        }
        return historyMessage.toString();
    }

    public void execute(Map<String, String> configurationMap, ConfluenceUser user) {
        log.debug("Started JobRunner contentChanges");
        this.saveResults("in progress", "Preparing to content changes...", new HashMap<String, ContentChangerResult>());
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        try {
            String sourceUserName = configurationMap.get("sourceUserName");
            ConfluenceUser sourceUser = this.userAccessor.getUserByName(sourceUserName);
            log.debug("> sourceUser found = " + (sourceUser != null));
            String targetUserName = configurationMap.get("targetUserName");
            ConfluenceUser targetUser = this.userAccessor.getUserByName(targetUserName);
            log.debug("> targetUser found = " + (targetUser != null));
            HashMap<String, ContentChangerResult> contentChangerResultMap = new HashMap<String, ContentChangerResult>();
            for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
                boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
                if (!this.userAnonymizerChangerManager.hasCommonChanger(entry.getKey()) || !valueIsTrue) continue;
                BasicContentChanger changer = this.userAnonymizerChangerManager.getCommonChanger(entry.getKey());
                ContentChangerResult contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent(null, sourceUser)) : changer.changeIssues(TASK_KEY, null, sourceUser, targetUser);
                this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
            }
            List<AbstractPage> pages = this.pageService.getPages(configurationMap.get("cql"));
            int pageCounter = 0;
            for (AbstractPage page : pages) {
                for (Map.Entry<String, String> entry : configurationMap.entrySet()) {
                    ContentChangerResult contentChangerResult;
                    BasicContentChanger changer;
                    boolean valueIsTrue = Boolean.parseBoolean(configurationMap.get(entry.getKey()));
                    if (this.userAnonymizerChangerManager.hasPageChanger(entry.getKey()) && valueIsTrue) {
                        changer = this.userAnonymizerChangerManager.getPageChanger(entry.getKey());
                        contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent((EntityObject)page, sourceUser)) : changer.changeIssues(TASK_KEY, (EntityObject)page, sourceUser, targetUser);
                        this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
                    }
                    if (!this.userAnonymizerChangerManager.hasSpaceChanger(entry.getKey()) || !valueIsTrue) continue;
                    changer = this.userAnonymizerChangerManager.getSpaceChanger(entry.getKey());
                    contentChangerResult = configurationMap.get("taskType").equals("search") ? new ContentChangerResult(changer.getChangerName(), changer.getAffectedContent((EntityObject)page.getSpace(), sourceUser)) : changer.changeIssues(TASK_KEY, (EntityObject)page.getSpace(), sourceUser, targetUser);
                    this.putContentChangerResultValue(contentChangerResultMap, contentChangerResult);
                }
                this.saveResults("in progress", "Task in progress. Proceed pages " + ++pageCounter + " from " + pages.size(), contentChangerResultMap);
            }
            try {
                ManagedCache cpCache;
                ManagedCache cpsCache = this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermissionSet");
                if (cpsCache != null) {
                    cpsCache.clear();
                }
                if ((cpCache = this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermission")) != null) {
                    cpCache.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.saveResults("done", "finished", contentChangerResultMap);
            log.debug("Finished JobRunner contentChanges");
        }
        catch (Exception e) {
            this.saveResults(TASK_KEY, "Failed!", new HashMap<String, ContentChangerResult>());
            log.debug("Failed JobRunner contentChanges");
            e.printStackTrace();
        }
    }

    private void putContentChangerResultValue(Map<String, ContentChangerResult> contentChangerResultMap, ContentChangerResult value) {
        String changerName = value.getChangerName();
        if (contentChangerResultMap.containsKey(changerName)) {
            ContentChangerResult tempValue = contentChangerResultMap.get(changerName);
            if (!tempValue.getAffectedContent().contains(value.getAffectedContent())) {
                tempValue.setAffectedContent(tempValue.getAffectedContent() + value.getAffectedContent());
            }
            if (!tempValue.getBadlyChanged().contains(value.getBadlyChanged())) {
                tempValue.setBadlyChanged(tempValue.getBadlyChanged() + value.getBadlyChanged());
            }
            if (!tempValue.getSuccessfullyChanged().contains(value.getSuccessfullyChanged())) {
                tempValue.setSuccessfullyChanged(tempValue.getSuccessfullyChanged() + value.getSuccessfullyChanged());
            }
            contentChangerResultMap.put(changerName, tempValue);
        } else {
            contentChangerResultMap.put(changerName, value);
        }
    }

    public String getTaskResult() {
        Object jobStatusObj = this.pluginSettings.get(TASK_KEY);
        return (String)jobStatusObj;
    }

    public void removeTaskResult() {
        this.pluginSettings.remove(TASK_KEY);
    }

    private void saveResults(String status, String message, Map<String, ContentChangerResult> map) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("status", status);
        messageMap.put("message", message);
        messageMap.put("results", new ArrayList<ContentChangerResult>(map.values()));
        this.pluginSettings.put(TASK_KEY, (Object)new Gson().toJson(messageMap));
    }
}

