/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.rest.template;

import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.model.GDPRPublishModel;
import de.actonic.gdpr.shared.general.model.GDPRSearchResultModel;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import de.actonic.gdpr.shared.newDC.model.template.TemplateDCModel;
import de.actonic.gdpr.shared.newDC.service.template.TemplateDCService;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/templates")
@Produces(value={"application/json"})
public class TemplateDCRest {
    private static final Logger log = LoggerFactory.getLogger(TemplateDCRest.class);
    private final TemplateDCService templateService;

    @Autowired
    public TemplateDCRest(TemplateDCService templateService) {
        this.templateService = templateService;
    }

    @POST
    @Path(value="/")
    public Response createTemplate() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel template = this.templateService.createSimpleTemplate();
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/")
    public Response getTemplates(@QueryParam(value="templateType") String templateType, @QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit, @QueryParam(value="name") String name, @QueryParam(value="status") Boolean isEnable, @QueryParam(value="type") String type) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            GDPRSearchResultModel templates = this.templateService.getTemplates(page, limit, name, isEnable, type, templateType);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)templates)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getTemplateById(@PathParam(value="id") Integer id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel template = this.templateService.getTemplateById(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}/draft")
    public Response getDraftTemplateByParentId(@PathParam(value="id") Integer id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel draftTemplate = this.templateService.getDraftTemplateByParentId(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)draftTemplate)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/publish")
    public Response publishTemplate(@PathParam(value="id") Integer id, @RequestBody GDPRPublishModel publishModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel template = this.templateService.publishTemplate(id, publishModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/{id}")
    public Response updateTemplate(@PathParam(value="id") Integer id, @RequestBody TemplateDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            requestModel.setId(id);
            TemplateDCModel template = this.templateService.updateTemplate(requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteTemplate(@PathParam(value="id") Integer id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.templateService.deleteTemplate(id);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/revert")
    public Response revertTemplate(@PathParam(value="id") Integer id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel template = this.templateService.revertTemplate(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/restore")
    public Response restoreTemplate(@PathParam(value="id") Integer id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            TemplateDCModel template = this.templateService.restoreTemplate(id);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)template)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/restoreAll")
    public Response restoreAllTemplates() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List templates = this.templateService.restoreAllTemplates();
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.getGsonWithDateFormat().toJson((Object)templates)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

