/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.pages.TrashManagerInternal;
import com.atlassian.confluence.pages.AbstractPage;
import com.google.common.collect.Lists;
import de.actonic.gdpr.datacleaner.model.DCConfluenceContentObject;
import de.actonic.gdpr.shared.datacleaner.model.IDCContentObject;
import de.actonic.gdpr.shared.datacleaner.model.template.IDCQueryParam;
import de.actonic.gdpr.shared.datacleaner.service.IDCCustomSearchIterator;
import de.actonic.gdpr.shared.general.model.GDPRUserModel;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class DCTrashedCustomSearchIterator
implements IDCCustomSearchIterator {
    private final Integer NUMBER_OF_PAGES = 5000;
    private final TrashManagerInternal trashManager;
    private List<AbstractPage> pages = null;
    private Integer pageCount;
    private List<String> spaceKeys;
    private Integer keyIndex;
    private Integer total;
    private Integer pageIndex;
    private ListIterator<AbstractPage> pageIterator;

    public DCTrashedCustomSearchIterator(TrashManagerInternal trashManager) {
        this.trashManager = trashManager;
    }

    public void init(IDCQueryParam queryParam, GDPRUserModel user) throws Exception {
        this.keyIndex = 0;
        this.pageIndex = 0;
        this.pageCount = 0;
        this.spaceKeys = Lists.newArrayList((Object[])queryParam.getQuery().split(","));
        Collections.sort(this.spaceKeys);
        List trashedEntities = this.trashManager.getTrashedEntities(Long.parseLong(this.spaceKeys.get(this.keyIndex)), this.NUMBER_OF_PAGES.intValue());
        this.pages = trashedEntities.stream().map(ceo -> (AbstractPage)ceo).collect(Collectors.toList());
        this.total = this.pages.size();
        this.pageIterator = this.pages.listIterator();
    }

    public Boolean hasNext() {
        if (!this.pageIterator.hasNext()) {
            this.updatePages();
        }
        return this.pageIterator.hasNext();
    }

    public Boolean hasNextInCurrentScope() {
        return this.pageCount < this.pages.size();
    }

    public IDCContentObject next() {
        AbstractPage abstractPage = this.pages.get(this.pageIndex);
        Integer n = this.pageIndex;
        Integer n2 = this.pageIndex = Integer.valueOf(this.pageIndex + 1);
        n = this.keyIndex;
        n2 = this.keyIndex = Integer.valueOf(this.keyIndex + 1);
        n = this.pageCount;
        n2 = this.pageCount = Integer.valueOf(this.pageCount + 1);
        if (this.pageIndex > this.NUMBER_OF_PAGES) {
            this.updatePages();
        }
        return DCConfluenceContentObject.builder().ceo((ContentEntityObject)abstractPage).build();
    }

    public Integer total() {
        return this.total;
    }

    private void updatePages() {
        this.pageIndex = 0;
        this.pageCount = 0;
        String spaceKey = this.spaceKeys.get(this.keyIndex);
        List trashedEntities = this.trashManager.getTrashedEntities(Long.parseLong(spaceKey), this.NUMBER_OF_PAGES.intValue());
        this.pages = trashedEntities.stream().map(ceo -> (AbstractPage)ceo).collect(Collectors.toList());
        this.pageIterator = this.pages.listIterator();
    }
}

