/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerRuleEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerRuleDao;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerRuleService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerRuleService.class);
    private final DataCleanerRuleDao dataCleanerRuleDao;

    @Autowired
    public DataCleanerRuleService(DataCleanerRuleDao dataCleanerRuleDao) {
        this.dataCleanerRuleDao = dataCleanerRuleDao;
    }

    private DataCleanerRuleModel entityToModel(DataCleanerRuleEntity entity) {
        DataCleanerRuleModel model = DataCleanerRuleModel.builder().id(entity.getID()).templateId(entity.getTemplateId()).enabled(entity.getEnabled()).name(entity.getName()).searchType(entity.getSearchType()).searchString(entity.getSearchString()).replaceType(entity.getReplaceType()).replaceString(entity.getReplaceString()).build();
        return model;
    }

    public DataCleanerRuleModel createRule(DataCleanerRuleModel ruleModel) {
        DataCleanerRuleEntity entity = this.dataCleanerRuleDao.createEntity(ruleModel.getTemplateId(), ruleModel.isEnabled(), ruleModel.getName(), ruleModel.getSearchType(), ruleModel.getSearchString(), ruleModel.getReplaceType(), ruleModel.getReplaceString());
        return this.entityToModel(entity);
    }

    public DataCleanerRuleModel updateRule(int ruleId, DataCleanerRuleModel ruleModel) {
        DataCleanerRuleEntity entity = this.dataCleanerRuleDao.updateEntity(ruleId, ruleModel.isEnabled(), ruleModel.getName(), ruleModel.getSearchType(), ruleModel.getSearchString(), ruleModel.getReplaceType(), ruleModel.getReplaceString());
        return this.entityToModel(entity);
    }

    public DataCleanerRuleModel getRule(int ruleId) {
        DataCleanerRuleEntity entity = this.dataCleanerRuleDao.getById(ruleId);
        return this.entityToModel(entity);
    }

    public void changeRuleState(int ruleId, boolean newState) {
        if (newState) {
            this.dataCleanerRuleDao.enable(ruleId);
        } else {
            this.dataCleanerRuleDao.disable(ruleId);
        }
    }

    public void deleteRule(int id) {
        this.dataCleanerRuleDao.deleteEntity(id);
    }

    public List<DataCleanerRuleModel> getAllRules() {
        return this.dataCleanerRuleDao.getAllEntities().stream().map(e -> this.entityToModel((DataCleanerRuleEntity)e)).collect(Collectors.toList());
    }

    public List<DataCleanerRuleModel> getRules(int templateId) {
        return this.dataCleanerRuleDao.getRules(templateId).stream().map(e -> this.entityToModel((DataCleanerRuleEntity)e)).collect(Collectors.toList());
    }

    public List<DataCleanerRuleModel> getRules(List<Integer> ruleIds) {
        return ruleIds.stream().map(this::getRule).collect(Collectors.toList());
    }

    public List<DataCleanerRuleModel> getEnabledRules(int templateId) {
        return this.dataCleanerRuleDao.getEnabledRules(templateId).stream().map(e -> this.entityToModel((DataCleanerRuleEntity)e)).collect(Collectors.toList());
    }

    public void deleteRulesByTemplateId(int templateId) {
        this.dataCleanerRuleDao.deleteEntityByTemplateId(templateId);
    }
}

