(function (delayedFunctionsMachine, $, undefined) {
    delayedFunctionsMachine.eventHandlers = {};
    delayedFunctionsMachine.addDelayedFunction = function (timeOut, functionName, handler) {
        if (!this.eventHandlers[functionName] || !Array.isArray(this.eventHandlers[functionName])) {
            this.eventHandlers[functionName] = [];
        } else {
            this.eventHandlers[functionName].forEach(function (timer) {
                clearTimeout(timer);
            });
        }

        var timer = setTimeout(function () {
            if (typeof handler === "function") {
                handler();
            }
        }, timeOut);

        this.eventHandlers[functionName].push(timer);
    }
}(window.delayedFunctionsMachine = window.delayedFunctionsMachine || {}, jQuery));

