define("gdpr/data-cleaner/rest", ["jquery", "gdpr/core/log", "actonic-gdpr/core/flags"], function ($, log, flags) {
    function Rest() {
        this.getAll = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };

        this.getById = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }

        this.getAllSpaces = function (param,successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/spaces?q="+param,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }

        this.draft = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/draft",
                data: JSON.stringify(request),
                async: false,
                cache: false,
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.create = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template",
                data: JSON.stringify(request),
                async: false,
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }

        this.update = function (id, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/" + id,
                data: JSON.stringify(request),
                cache: false,
                async: false,
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.delete = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "DELETE",
                url: AJS.contextPath() + '/rest/actonic-gdpr/1.0/data-cleaner-template/' + id,
                cache: false,
                async: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }

        this.clone = function (templateId, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/clone/" + templateId,
                async: false,
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }

        this.getDataRulesConfigurationStatus = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/status",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.getUserDetails = function (sourceUserName, targetUserName, successCallback) {
            $.ajax({
                type: "GET",
                dataType: "json",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user?query=" + sourceUserName,
                success: function (sourceUserDetails) {
                    $.ajax({
                        type: "GET",
                        dataType: "json",
                        url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user?query=" + targetUserName,
                        success: function (targetUserDetails) {
                            //console.log("sourceUserDetails: " + sourceUserDetails);
                            //console.log("targetUserDetails: " + targetUserDetails);
                            successCallback(sourceUserDetails, targetUserDetails);
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            log.error(jqXHR);
                            flags.simpleWarning(jqXHR.responseJSON.errorMessages);
                        }
                    });
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    log.error(jqXHR);
                    flags.simpleWarning(jqXHR.responseJSON.errorMessages);
                }
            });
        };

        this.checkCql = function (cql, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/cql" ,
                data: {cql: cql},
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.quickUserAnonymize = function (id, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/task/quick-user-anonymize/",
                data: JSON.stringify(request),
                cache: false,
                async: false,
                headers: {
                    "Content-Type": "application/json"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }

    return new Rest();
});
