/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.scheduling;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.actonic.gdpr.newDC.scheduling.TackDCJob;
import de.actonic.gdpr.newDC.scheduling.TackEventDCJob;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@ExportAsService(value={LifecycleAware.class})
public class TaskDCJobStarter
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(TaskDCJobStarter.class);
    private final JobRunnerKey SCHEDULED_EVENT_JOB_KEY = JobRunnerKey.of((String)TackEventDCJob.class.getName());
    private final JobRunnerKey SCHEDULED_JOB_KEY = JobRunnerKey.of((String)TackDCJob.class.getName());
    @ComponentImport
    private final SchedulerService schedulerService;
    private final TackDCJob tackJob;
    private final TackEventDCJob tackEventJob;
    private static final Long INTERVAL = 5000L;
    private static final Long MIN_DELAY = 15000L;

    public TaskDCJobStarter(SchedulerService schedulerService, TackDCJob tackJob, TackEventDCJob tackEventJob) {
        this.schedulerService = schedulerService;
        this.tackJob = tackJob;
        this.tackEventJob = tackEventJob;
    }

    public void onStart() {
        log.info("starting onStart");
        this.schedulerService.registerJobRunner(this.SCHEDULED_JOB_KEY, (JobRunner)this.tackJob);
        this.schedulerService.registerJobRunner(this.SCHEDULED_EVENT_JOB_KEY, (JobRunner)this.tackEventJob);
        try {
            this.schedulerService.scheduleJobWithGeneratedId(this.createJobConfig(this.SCHEDULED_JOB_KEY));
            this.schedulerService.scheduleJobWithGeneratedId(this.createJobConfig(this.SCHEDULED_EVENT_JOB_KEY));
            log.info("Schedule created");
        }
        catch (Exception e) {
            log.info("There was a problem in creating the schedule");
        }
        log.info("finished onStart");
    }

    private JobConfig createJobConfig(JobRunnerKey jobRunnerKey) {
        Date firstRun = new Date(System.currentTimeMillis() + MIN_DELAY);
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(Schedule.forInterval((long)INTERVAL, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
    }

    public void onStop() {
        log.info("starting onStop");
        List jobs = this.schedulerService.getJobsByJobRunnerKey(this.SCHEDULED_JOB_KEY);
        jobs.addAll(this.schedulerService.getJobsByJobRunnerKey(this.SCHEDULED_EVENT_JOB_KEY));
        jobs.forEach(job -> this.schedulerService.unscheduleJob(job.getJobId()));
        this.schedulerService.unregisterJobRunner(this.SCHEDULED_JOB_KEY);
        this.schedulerService.unregisterJobRunner(this.SCHEDULED_EVENT_JOB_KEY);
        log.info("finished onStop");
    }
}

