/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.rest.template;

import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import de.actonic.gdpr.shared.newDC.model.template.IgnoredListDCModel;
import de.actonic.gdpr.shared.newDC.service.template.ignoreList.IgnoredListDCService;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/templates/ignoredList")
@Produces(value={"application/json"})
public class IgnoredListDCRest {
    private static final Logger log = LoggerFactory.getLogger(IgnoredListDCRest.class);
    private final IgnoredListDCService ignoredListService;

    public IgnoredListDCRest(IgnoredListDCService ignoredListService) {
        this.ignoredListService = ignoredListService;
    }

    @POST
    @Path(value="/")
    public Response createIgnoredList(IgnoredListDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            IgnoredListDCModel ignoredList = this.ignoredListService.createIgnoredList(requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)ignoredList)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

