/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.model;

import java.util.Date;

public class EventModel {
    private Date date;
    private String type;
    private String author;
    private String userName;
    private String summary;
    private String details;

    public static EventModelBuilder builder() {
        return new EventModelBuilder();
    }

    public EventModel(Date date, String type, String author, String userName, String summary, String details) {
        this.date = date;
        this.type = type;
        this.author = author;
        this.userName = userName;
        this.summary = summary;
        this.details = details;
    }

    public Date getDate() {
        return this.date;
    }

    public String getType() {
        return this.type;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDetails() {
        return this.details;
    }

    public static class EventModelBuilder {
        private Date date;
        private String type;
        private String author;
        private String userName;
        private String summary;
        private String details;

        EventModelBuilder() {
        }

        public EventModelBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public EventModelBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EventModelBuilder author(String author) {
            this.author = author;
            return this;
        }

        public EventModelBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public EventModelBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public EventModelBuilder details(String details) {
            this.details = details;
            return this;
        }

        public EventModel build() {
            return new EventModel(this.date, this.type, this.author, this.userName, this.summary, this.details);
        }

        public String toString() {
            return "EventModel.EventModelBuilder(date=" + this.date + ", type=" + this.type + ", author=" + this.author + ", userName=" + this.userName + ", summary=" + this.summary + ", details=" + this.details + ")";
        }
    }
}

