/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerHistoryModel;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerHistoryEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerHistoryDao;
import de.actonic.confluence.gdpr.model.ListPaginationModel;
import de.actonic.confluence.gdpr.util.PaginationUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerResultService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerResultService.class);
    private final PaginationUtils paginationUtils;
    private DataCleanerHistoryDao dataCleanerHistoryDao;

    @Autowired
    public DataCleanerResultService(DataCleanerHistoryDao dataCleanerHistoryDao, PaginationUtils paginationUtils) {
        this.dataCleanerHistoryDao = dataCleanerHistoryDao;
        this.paginationUtils = paginationUtils;
    }

    public DataCleanerHistoryModel getHistoryModelById(int historyModelId) {
        DataCleanerHistoryEntity dataCleanerHistoryEntity = this.dataCleanerHistoryDao.get(historyModelId);
        return dataCleanerHistoryEntity == null ? null : this.entityToModel(dataCleanerHistoryEntity);
    }

    public DataCleanerHistoryModel updateHistoryModel(DataCleanerHistoryModel dataCleanerHistoryModel) {
        DataCleanerHistoryEntity dataCleanerHistoryEntity = this.dataCleanerHistoryDao.get(dataCleanerHistoryModel.getId());
        if (dataCleanerHistoryEntity != null) {
            dataCleanerHistoryEntity.setData(dataCleanerHistoryModel.getData());
            dataCleanerHistoryEntity.setStatus(dataCleanerHistoryModel.getStatus());
            dataCleanerHistoryEntity.save();
        }
        return dataCleanerHistoryEntity == null ? null : this.entityToModel(dataCleanerHistoryEntity);
    }

    public List<DataCleanerHistoryModel> getResultsByTaskId(int taskId) {
        List<DataCleanerHistoryEntity> dataCleanerHistoryEntities = this.dataCleanerHistoryDao.getHistoryEntitiesByJobId(taskId);
        return this.entitiesToModels(dataCleanerHistoryEntities);
    }

    public DataCleanerHistoryModel entityToModel(DataCleanerHistoryEntity entity) {
        return DataCleanerHistoryModel.builder().id(entity.getID()).jobId(entity.getTaskId()).ruleId(entity.getRuleId()).data(entity.getData()).object(entity.getObject()).ceo(this.jsonStringToMap(entity.getCeo())).space(this.jsonStringToMap(entity.getSpace())).status(entity.getStatus()).ceoCreationDate(entity.getCeoCreationDate()).build();
    }

    public List<DataCleanerHistoryModel> entitiesToModels(List<DataCleanerHistoryEntity> entities) {
        return entities.stream().map(dataCleanerTaskEntity -> this.entityToModel((DataCleanerHistoryEntity)dataCleanerTaskEntity)).collect(Collectors.toList());
    }

    private Map<String, String> jsonStringToMap(String jsonString) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map stringMap = (Map)new Gson().fromJson(jsonString, type);
        return stringMap;
    }

    public ListPaginationModel getFilteredResults(Integer taskId, Integer page, Integer maxCount, String projects, String objects, String status, String rules, String sortBy) {
        List<String> params;
        Query query = Query.select();
        ArrayList whereParams = Lists.newArrayList();
        StringBuilder builder = new StringBuilder();
        builder.append("TASK_ID = ?");
        whereParams.add(taskId);
        if (StringUtils.isNotBlank((String)projects)) {
            params = this.convertStringToArray(projects);
            builder.append(" and (" + this.fixSqlQueryParamsForProject(params.size()) + ")");
            for (String param : params) {
                whereParams.add("%\"" + param + "\"%");
            }
        }
        if (StringUtils.isNotBlank((String)objects)) {
            params = this.convertStringToArray(objects);
            builder.append(" and OBJECT in (" + this.fixSqlQueryParams(params.size()) + ")");
            whereParams.addAll(params);
        }
        if (StringUtils.isNotBlank((String)status)) {
            params = this.convertStringToArray(status);
            builder.append(" and STATUS in (" + this.fixSqlQueryParams(params.size()) + ")");
            whereParams.addAll(params.stream().map(Integer::parseInt).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((String)rules)) {
            params = this.convertStringToArray(rules);
            builder.append(" and RULE_ID in (" + this.fixSqlQueryParams(params.size()) + ")");
            whereParams.addAll(params.stream().map(Integer::parseInt).collect(Collectors.toList()));
        }
        query.setWhereClause(builder.toString());
        query.setWhereParams(whereParams.toArray());
        int entitiesSize = this.paginationUtils.getEntitiesSize(DataCleanerHistoryEntity.class, query);
        switch (Integer.parseInt(sortBy)) {
            case 0: {
                query.setOrderClause("ID ASC");
                break;
            }
            case 1: {
                query.setOrderClause("CEO_CREATION_DATE DESC");
                break;
            }
            case 2: {
                query.setOrderClause("CEO_CREATION_DATE ASC");
            }
        }
        ListPaginationModel model = this.paginationUtils.getPaginationObjectByQuery(DataCleanerHistoryEntity.class, query, page, maxCount, entitiesSize);
        ArrayList resultList = Lists.newArrayList();
        model.getObjList().forEach(el -> resultList.add(this.entityToModel((DataCleanerHistoryEntity)el)));
        return new ListPaginationModel(model.getCurrentPageNum(), model.getTotalPages(), resultList);
    }

    public ListPaginationModel getFilteredResults(Integer taskId, Integer page, String projects, String objects, String status, String rules, String sortBy) {
        return this.getFilteredResults(taskId, page, null, projects, objects, status, rules, sortBy);
    }

    private List<String> convertStringToArray(String params) {
        Object[] array = params.split(",");
        return Lists.newArrayList((Object[])array);
    }

    private String fixSqlQueryParams(int paramSize) {
        String str = "";
        for (int i = 0; i < paramSize; ++i) {
            str = str + "?,";
        }
        return str.substring(0, str.length() - 1);
    }

    private String fixSqlQueryParamsForProject(int paramSize) {
        String str = "";
        for (int i = 0; i < paramSize; ++i) {
            str = str + "SPACE LIKE ? OR ";
        }
        return str.substring(0, str.length() - 4);
    }

    public Map<String, String> getUniqProjectsByTaskId(Integer taskId) {
        if (taskId == null) {
            return new HashMap<String, String>();
        }
        return this.dataCleanerHistoryDao.getUniqProjectsByTasksId(taskId);
    }

    public void delete(int resultId) {
        this.dataCleanerHistoryDao.delete(resultId);
    }
}

