/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionModel;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerPostFunctionEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerPostFunctionDao;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerPostFunctionService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerPostFunctionService.class);
    private DataCleanerPostFunctionDao dataCleanerPostFunctionDao;

    @Autowired
    public DataCleanerPostFunctionService(DataCleanerPostFunctionDao dataCleanerPostFunctionDao) {
        this.dataCleanerPostFunctionDao = dataCleanerPostFunctionDao;
    }

    public void createPostFunction(DataCleanerPostFunctionModel dataCleanerPostFunctionModel) {
        Gson gson = new Gson();
        this.dataCleanerPostFunctionDao.createEntity(dataCleanerPostFunctionModel.getTemplateId(), dataCleanerPostFunctionModel.getName(), dataCleanerPostFunctionModel.getRules(), dataCleanerPostFunctionModel.getNotificationType(), dataCleanerPostFunctionModel.isAnyRuleEnabled(), gson.toJson(dataCleanerPostFunctionModel.getNotificationParameters()), dataCleanerPostFunctionModel.isEnabled());
    }

    public void updatePostFunction(DataCleanerPostFunctionModel dataCleanerPostFunctionModel) {
        Gson gson = new Gson();
        this.dataCleanerPostFunctionDao.updateEntity(dataCleanerPostFunctionModel.getId(), dataCleanerPostFunctionModel.getName(), dataCleanerPostFunctionModel.getRules(), dataCleanerPostFunctionModel.getNotificationType(), dataCleanerPostFunctionModel.isAnyRuleEnabled(), gson.toJson(dataCleanerPostFunctionModel.getNotificationParameters()));
    }

    public List<DataCleanerPostFunctionModel> getAllPostFunctions(int templateId) {
        return this.dataCleanerPostFunctionDao.getAllEntitiesByTemplateId(templateId).stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public List<DataCleanerPostFunctionModel> getPostFunctionsByTemplateAndRule(int templateId, int ruleId) {
        return this.dataCleanerPostFunctionDao.getPostFunctionsByTemplateAndRule(templateId, ruleId).stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public void deletePostFunction(int id) {
        this.dataCleanerPostFunctionDao.deleteEntityById(id);
    }

    public void deleteAllPostFunctions(int templateId) {
        this.dataCleanerPostFunctionDao.deleteEntitiesByTemplateId(templateId);
    }

    public void changeStatus(int id, boolean status) {
        this.dataCleanerPostFunctionDao.changeEntityStatus(id, status);
    }

    private Map<String, String> jsonStringToMap(String jsonString) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map stringMap = (Map)gson.fromJson(jsonString, type);
        return stringMap;
    }

    private DataCleanerPostFunctionModel entityToModel(DataCleanerPostFunctionEntity element) {
        return new DataCleanerPostFunctionModel(element.getID(), element.getTemplateId(), element.getName(), element.getIsEnabled(), element.getRules(), element.getNotificationType(), element.getIsAnyRuleEnabled(), this.jsonStringToMap(element.getNotificationParameters()));
    }
}

