/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Strings;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerReplaceModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleReplaceType;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleSearchType;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerFieldObjectTypeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerChangeService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerChangeService.class);
    @ComponentImport
    private UserAccessor userAccessor;
    private DataCleanerFieldObjectTypeManager dataCleanerFieldObjectTypeManager;
    private Map<Integer, Pattern> patternCompileMap = new HashMap<Integer, Pattern>();

    @Autowired
    public DataCleanerChangeService(UserAccessor userAccessor, DataCleanerFieldObjectTypeManager dataCleanerFieldObjectTypeManager) {
        this.userAccessor = userAccessor;
        this.dataCleanerFieldObjectTypeManager = dataCleanerFieldObjectTypeManager;
    }

    public void dropPatternCompileMap() {
        this.patternCompileMap = new HashMap<Integer, Pattern>();
    }

    private String returnSymbolRespectString(int size) {
        String result = "";
        for (int i = 0; i < size; ++i) {
            result = result + "\\#";
        }
        return result;
    }

    private String getReplaceStringByRule(String whatReplace, DataCleanerRuleModel rule) {
        if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleReplaceType.EMPTY_STRING.getType(), (CharSequence)rule.getReplaceType())) {
            return "";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleReplaceType.PLAIN_TEXT.getType(), (CharSequence)rule.getReplaceType())) {
            return rule.getReplaceString();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleReplaceType.SYMBOL.getType(), (CharSequence)rule.getReplaceType())) {
            return "\\#\\#\\#";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleReplaceType.SYMBOL_RESPECT_STRING.getType(), (CharSequence)rule.getReplaceType())) {
            return this.returnSymbolRespectString(whatReplace.length());
        }
        return null;
    }

    public Optional<DataCleanerReplaceModel> changeFieldByRules(String fieldValue, String objectValue, List<DataCleanerRuleModel> rules) {
        HashMap<Integer, String> matchedRulesMap = new HashMap<Integer, String>();
        if (!Strings.isNullOrEmpty((String)fieldValue)) {
            for (DataCleanerRuleModel rule : rules) {
                ConfluenceUser targetUser;
                String tmp;
                if (!this.ruleRelatedToObject(objectValue, rule)) continue;
                String searchString = rule.getSearchString();
                String replaceString = "";
                LinkedHashSet<String> foundMatches = new LinkedHashSet<String>();
                if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.PLAIN.getType(), (CharSequence)rule.getSearchType())) {
                    if (!StringUtils.contains((CharSequence)fieldValue, (CharSequence)searchString)) continue;
                    replaceString = this.getReplaceStringByRule(searchString, rule);
                    fieldValue = StringUtils.replaceIgnoreCase((String)fieldValue, (String)searchString, (String)replaceString);
                    matchedRulesMap.put(rule.getId(), searchString);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.REGEX.getType(), (CharSequence)rule.getSearchType())) {
                    Pattern pattern;
                    boolean isAnyFound = false;
                    if (this.patternCompileMap.containsKey(rule.getId())) {
                        pattern = this.patternCompileMap.get(rule.getId());
                    } else {
                        pattern = Pattern.compile(searchString);
                        this.patternCompileMap.put(rule.getId(), pattern);
                    }
                    Matcher matcher = pattern.matcher(fieldValue);
                    while (matcher.find()) {
                        foundMatches.add(matcher.group());
                        replaceString = this.getReplaceStringByRule(searchString, rule);
                        isAnyFound = true;
                    }
                    if (!isAnyFound) continue;
                    if (replaceString != null) {
                        fieldValue = matcher.replaceAll(replaceString);
                    }
                    searchString = this.convertSetToString(foundMatches);
                    matchedRulesMap.put(rule.getId(), searchString);
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.USER.getType(), (CharSequence)rule.getSearchType())) {
                    ConfluenceUser sourceUser = this.userAccessor.getUserByName(rule.getSearchString());
                    ConfluenceUser targetUser2 = this.userAccessor.getUserByName(rule.getReplaceString());
                    if (sourceUser == null || targetUser2 == null) continue;
                    if (fieldValue.equalsIgnoreCase(sourceUser.getKey().toString())) {
                        fieldValue = targetUser2.getKey().toString();
                        matchedRulesMap.put(rule.getId(), sourceUser.getKey() + " (" + sourceUser.getName() + ")");
                    } else if (fieldValue.contains(sourceUser.getKey().toString())) {
                        fieldValue = fieldValue.replaceAll(sourceUser.getKey().toString(), targetUser2.getKey().toString());
                        matchedRulesMap.put(rule.getId(), sourceUser.getKey() + " (" + sourceUser.getName() + ")");
                    }
                    if (!fieldValue.contains(sourceUser.getFullName())) continue;
                    fieldValue = fieldValue.replaceAll(sourceUser.getFullName(), targetUser2.getFullName());
                    matchedRulesMap.put(rule.getId(), sourceUser.getFullName() + " (" + sourceUser.getFullName() + ")");
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.ANY_USER.getType(), (CharSequence)rule.getSearchType())) continue;
                if (StringUtils.contains((CharSequence)this.dataCleanerFieldObjectTypeManager.getTypeByField(objectValue), (CharSequence)"text") && !StringUtils.equals((CharSequence)(tmp = fieldValue), (CharSequence)(fieldValue = this.replaceMentionUsers(fieldValue, rule)))) {
                    searchString = this.convertSetToString(foundMatches);
                    matchedRulesMap.put(rule.getId(), searchString);
                }
                if (!StringUtils.contains((CharSequence)this.dataCleanerFieldObjectTypeManager.getTypeByField(objectValue), (CharSequence)"user") || (targetUser = this.userAccessor.getUserByName(rule.getReplaceString())) == null || StringUtils.equalsIgnoreCase((CharSequence)targetUser.getKey().toString(), (CharSequence)fieldValue)) continue;
                matchedRulesMap.put(rule.getId(), fieldValue);
                fieldValue = targetUser.getKey().toString();
            }
        }
        return matchedRulesMap.size() > 0 ? Optional.of(new DataCleanerReplaceModel(fieldValue, matchedRulesMap)) : Optional.empty();
    }

    private String replaceMentionUsers(String targetString, DataCleanerRuleModel rule) {
        String searchString = "userkey=([^\\s]+)";
        ConfluenceUser targetUser = this.userAccessor.getUserByName(rule.getReplaceString());
        return targetString.replaceAll(searchString, "userkey=\"" + targetUser.getKey() + "\"");
    }

    private String convertSetToString(HashSet<String> data) {
        StringBuilder result = new StringBuilder();
        data.forEach(d -> result.append((String)d).append("<br>"));
        return result.toString();
    }

    public Optional<DataCleanerReplaceModel> changeFieldByRulesForAny(String fieldValue, String objectValue, List<DataCleanerRuleModel> rules) {
        HashMap<Integer, String> matchedRulesMap = new HashMap<Integer, String>();
        if (!Strings.isNullOrEmpty((String)fieldValue)) {
            for (DataCleanerRuleModel rule : rules) {
                ConfluenceUser targetUser;
                if (!this.ruleRelatedToObject(objectValue, rule)) continue;
                String searchString = rule.getSearchString();
                String replaceString = "";
                if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.PLAIN.getType(), (CharSequence)rule.getSearchType())) {
                    if (!searchString.equals("[~any-user-name]")) continue;
                    boolean isAnyFound = false;
                    Pattern pattern = Pattern.compile("\\[\\~(.)+\\]");
                    Matcher matcher = pattern.matcher(fieldValue);
                    while (matcher.find()) {
                        searchString = matcher.group();
                        replaceString = this.getReplaceStringByRule(searchString, rule);
                        if (replaceString != null) {
                            fieldValue = matcher.replaceAll(replaceString);
                        }
                        isAnyFound = true;
                    }
                    if (!isAnyFound) continue;
                    matchedRulesMap.put(rule.getId(), searchString);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.ANY_USER.getType(), (CharSequence)rule.getSearchType()) || (targetUser = this.userAccessor.getUserByName(rule.getReplaceString())) == null || StringUtils.equalsIgnoreCase((CharSequence)targetUser.getKey().toString(), (CharSequence)fieldValue)) continue;
                matchedRulesMap.put(rule.getId(), fieldValue);
                fieldValue = targetUser.getKey().toString();
            }
        }
        return matchedRulesMap.size() > 0 ? Optional.of(new DataCleanerReplaceModel(fieldValue, matchedRulesMap)) : Optional.empty();
    }

    public boolean ruleRelatedToObject(String object, DataCleanerRuleModel rule) {
        String type = this.dataCleanerFieldObjectTypeManager.getTypeByField(object);
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"text", (CharSequence)type)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.PLAIN.getType()) || StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.REGEX.getType()) || StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.ANY_USER.getType()) || StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.USER.getType())) {
                return true;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"user", (CharSequence)type)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.USER.getType()) || StringUtils.equalsIgnoreCase((CharSequence)rule.getSearchType(), (CharSequence)DataCleanerRuleSearchType.ANY_USER.getType())) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

