/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTemplateEntity;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTemplateDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTemplateDao.class);

    @Autowired
    public DataCleanerTemplateDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public DataCleanerTemplateEntity getById(int id) {
        return this.getFirstByField(DataCleanerTemplateEntity.class, "ID", id);
    }

    public DataCleanerTemplateEntity createDraftEntity(String creator) {
        DataCleanerTemplateEntity entity = (DataCleanerTemplateEntity)this.ao.create(DataCleanerTemplateEntity.class, new DBParam[0]);
        entity.setDraft(true);
        entity.setCreator(creator);
        entity.setCreationDate(new Date());
        entity.setLastModifier(creator);
        entity.setLastModificationDate(new Date());
        entity.setName("");
        entity.save();
        return entity;
    }

    public DataCleanerTemplateEntity createEntity(boolean enabled, String name, String creator, String cql, String cqlType, String objects, String notificationType, String notificationParameters) {
        DataCleanerTemplateEntity entity = (DataCleanerTemplateEntity)this.ao.create(DataCleanerTemplateEntity.class, new DBParam[0]);
        entity.setEnabled(enabled);
        entity.setDraft(false);
        entity.setName(name);
        entity.setCreator(creator);
        entity.setCreationDate(new Date());
        entity.setLastModificationDate(new Date());
        entity.setLastModifier(creator);
        entity.setCql(cql);
        entity.setCqlType(cqlType);
        entity.setObjects(objects);
        entity.setNotificationType(notificationType);
        entity.setNotificationParameters(notificationParameters);
        entity.save();
        return entity;
    }

    public DataCleanerTemplateEntity updateEntity(int id, boolean enabled, boolean isDraft, String name, String modifier, String cql, String cqlType, String objects, String notificationType, String notificationParameters) {
        DataCleanerTemplateEntity entity = this.getFirstByField(DataCleanerTemplateEntity.class, "ID", id);
        entity.setEnabled(enabled);
        entity.setDraft(isDraft);
        entity.setName(name);
        entity.setLastModificationDate(new Date());
        entity.setLastModifier(modifier);
        entity.setCql(cql);
        entity.setCqlType(cqlType);
        entity.setObjects(objects);
        entity.setNotificationType(notificationType);
        entity.setNotificationParameters(notificationParameters);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        DataCleanerTemplateEntity entity = this.getFirstByField(DataCleanerTemplateEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public List<DataCleanerTemplateEntity> getAllEntities() {
        return Lists.newArrayList((Object[])this.ao.find(DataCleanerTemplateEntity.class, Query.select().order("ID ASC")));
    }

    public DataCleanerTemplateEntity disable(int id) {
        return this.setEnableDisableState(id, "[system]", Boolean.FALSE);
    }

    public DataCleanerTemplateEntity enable(int id) {
        return this.setEnableDisableState(id, "[system]", Boolean.TRUE);
    }

    public DataCleanerTemplateEntity disable(int id, ConfluenceUser applicationUser) {
        return this.setEnableDisableState(id, applicationUser.getName(), Boolean.FALSE);
    }

    public DataCleanerTemplateEntity enable(int id, ConfluenceUser applicationUser) {
        return this.setEnableDisableState(id, applicationUser.getName(), Boolean.TRUE);
    }

    public DataCleanerTemplateEntity setEnableDisableState(int id, String userName, boolean isEnabled) {
        DataCleanerTemplateEntity entity = this.getFirstByField(DataCleanerTemplateEntity.class, "ID", id);
        entity.setEnabled(isEnabled);
        entity.setLastModificationDate(new Date());
        entity.setLastModifier(userName);
        entity.save();
        return entity;
    }
}

