/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Strings;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionService {
    @ComponentImport
    private final UserAccessor userAccessor;
    private final GDPRSettingsManager GDPRSettingsManager;

    @Autowired
    public ConditionService(UserAccessor userAccessor, GDPRSettingsManager GDPRSettingsManager2) {
        this.userAccessor = userAccessor;
        this.GDPRSettingsManager = GDPRSettingsManager2;
    }

    public boolean shouldDisplay() {
        String username = AuthenticatedUserThreadLocal.getUsername();
        String runGdprGroup = this.GDPRSettingsManager.getAllowedGroup();
        if (Strings.isNullOrEmpty((String)username)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)runGdprGroup)) {
            return true;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        return this.userAccessor.hasMembership(runGdprGroup, user.getName());
    }
}

