(function (eventmachine, $, undefined) {
    eventmachine.firstCallStatus = {"TableChangeEvent": false, "ProjectsReceived": false};
    eventmachine.eventHandlers = {}; // possible items "TableChangeEvent", "ProjectsReceived"

    eventmachine.addHandler = function (event, handler) {
        if (!this.eventHandlers[event] || !Array.isArray(this.eventHandlers[event])) {
            this.eventHandlers[event] = [];
        }
        this.eventHandlers[event].push(handler);
    };
    eventmachine.addSingleHandler = function (event, handler, data) {
        if (!this.eventHandlers[event] || !Array.isArray(this.eventHandlers[event])) {
            this.eventHandlers[event] = [];
        }
        if (this.firstCallStatus[event]) {
            handler(data);
        } else {
            this.eventHandlers[event].push(handler);
        }
    };
    eventmachine.addSingletonHandler = function (event, handler) {
        this.eventHandlers[event] = [];
        this.eventHandlers[event].push(handler);
    };
    eventmachine.callEvent = function (event, data) {
        if (!this.firstCallStatus[event]) {
            this.firstCallStatus[event] = true;
        }
        if (this.eventHandlers[event] && Array.isArray(this.eventHandlers[event])) {
            this.eventHandlers[event].forEach(function (handler) {
                handler(data);
            });
        }
    };
}(window.eventmachine = window.eventmachine || {}, jQuery));

