define("actonic-gdpr/request-my-data/execute",
    ["jquery", "actonic-gdpr/request-my-data/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/picker"],
    function ($, Rest, flag, Picker) {

    function Execute() {
        this.init = function () {
            setTimeout(processRequest, 500);
            getHistory();
            getRequestQueue();

            $("#create-request").on("click", function (event) {
                event.preventDefault();
                var user = $("#request-user").val();
                if (user)
                    Rest.createRequest(user, function (data) {
                        if (data) {
                            flag.simpleSuccess("Request successfully created.");
                            setTimeout(processRequest, 1000);
                        } else flag.simpleWarning("Request for this user already exists. You can not create other, while previous request doesn't finish");
                    }, function () {
                    });
                else flag.simpleWarning("User must not be empty. Please, specify user");
            });

            $("#cancel-request").live("click", function (event) {
                var requestId = parseInt($(this).attr("data-id"), 10);
                event.preventDefault();
                Rest.cancelRequest(requestId, function (data) {
                    flag.simpleSuccess("Request successfully cancelled.");
                    $(this).parent().parent().remove();
                })
            })

            Picker.initializeUserPicker("request-user");

            $("#li-current").on("click", function () {
                processRequest();
            })

            $("#li-queue").on("click", function () {
                getRequestQueue();
            })

            $("#li-history").on("click", function () {
                getHistory();
            })

            function getHistory() {
                Rest.getHistory(function (data) {
                    if (data.length != 0) {
                        var soyData = {
                            requests: data,
                            baseUrl: AJS.contextPath()
                        }
                        $("#history-requests").html(ACTONIC.GDPR.RMD.history(soyData))
                    } else {
                        $("#filter-select").disable();
                        $("#history-requests").html(ACTONIC.GDPR.RMD.empty())
                    }
                }, function () {
                    flag.simpleWarning("History - something went wrong. Please contact your confluence administrator")
                })
            }

            function getRequestQueue() {
                Rest.getRequestQueue(function (data) {
                    if (data.length != 0) {
                        var soyData = {
                            requests: data
                        }
                        $("#queue-requests").html(ACTONIC.GDPR.RMD.queue(soyData))
                    } else $("#queue-requests").html(ACTONIC.GDPR.RMD.empty())
                }, function () {
                    flag.simpleWarning("Queue - something went wrong. Please contact your confluence administrator")
                })
            }

            function processRequest() {
                Rest.getRequest("", function (data) {
                    //console.log(data);
                    if (data) {
                        var extra = "";
                        if (data.extraFields) extra = JSON.parse(data.extraFields);
                        var soyData = {
                            request: data,
                            extra: extra
                        }
                        $("#request").html(ACTONIC.GDPR.RMD.status(soyData))
                        setTimeout(processRequest, 3000);
                    } else {
                        $("#request").html(ACTONIC.GDPR.RMD.empty());
                    }
                }, function (xhr) {
                    // TODO
                })
            }
        }
    }

    return new Execute();
})
