define("actonic-gdpr/profile-visibility/intro", ["jquery", "actonic-gdpr/core/intro-rest"], function ($, CoreIntroRest) {

    var Intro = {
        init: function () {
            var username = AJS.Meta.get("remote-user");
            if (username) {
                CoreIntroRest.isIntroShowed("profile-visibility", username,
                    function (data) { // success
                        //log.debug(data);
                        if (!data) {
                            if (introJs) {
                                Intro.setIntroSteps();

                                var tour = introJs();
                                tour.setOption('tooltipPosition', 'auto');
                                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);
                                tour.start();
                            } else {
                                log.error("intro.cannot.load.introjs.not.found");
                            }
                        }
                    },
                    function (data) { // error
                        log.error("intro.cannot.load.connection.error " + data.responseText);
                    });
            } else {
                log.error("intro.cannot.load.user.not.found");
            }
        },
        showIntro: function() {
            if (introJs) {
                Intro.setIntroSteps();

                var tour = introJs();
                tour.setOption('tooltipPosition', 'auto');
                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);
                tour.start();
            } else {
                log.error("intro.cannot.load.introjs.not.found");
            }
        },
        setIntroSteps: function () {
            $("#select-state-radio-wrapper").attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-profile-visibility.intro.step-1"));
            $("#new-visibility-rule-wrapper").attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-profile-visibility.intro.step-2"));
        }
    }

    return Intro;
});
