define("actonic-gdpr/data-level-agreement-history/filter", ["jquery", "actonic-gdpr/data-level-agreement/rest", "actonic-gdpr/core/flags"], function ($, Rest, flags) {

    function Filter() {
        var items = [];
        var ignoreChangeEvents = false;

        this.init = function () {
            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#filter-button").click(function () {
                filterHistoryLogs(1);
            });

            $("#clear-button").click(function () {
                //log.debug("#clear-button.click");
                clearFilters();
            });

            $("#export-button").click(function () {
                location.href = AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement/export?" + getExportLink();
            });

            initializeTicketPicker();
            var ruleId = getParameterByName(location.href, "ruleId");
            if (ruleId) {
                initializeRulePicker(ruleId);
                $("#filter-button").click();
            } else {
                initializeRulePicker();
            }
        }

        function getParameterByName(url, name) {
            /*name = name.replace(/[\[\]]/g, "\\$&");
            var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';

            return decodeURIComponent(results[2].replace(/\+/g, " "));*/
            var url = new URL(url);
            return url.searchParams.get(name);
        }

        function getExportLink() {
            var pageId = $("#page-picker").val();
            var ruleId = $("#rule-picker").val();
            var orderBy = $("#sort-by-picker").val();
            var fromDate = moment($("#from-date-picker").val()).startOf("day").valueOf();
            var toDate = moment($("#to-date-picker").val()).endOf("day").valueOf();

            if (fromDate > toDate) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-dla-history.filter.flags.warning.date-before")
                });
                return;
            }

            if (fromDate > moment().endOf("day").valueOf()) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-dla-history.filter.flags.warning.date-after")
                });
                return;
            }

            var request = {
                ticketKey: pageId,
                ruleId: ruleId,
                orderBy: orderBy
            }

            if (fromDate) request.fromDate = fromDate;
            if (toDate) request.toDate = toDate

            return jQuery.param(request);
        }

        function clearFilters() {
            ignoreChangeEvents = true;
            initializeRulePicker();
            initializeTicketPicker();
            ignoreChangeEvents = false;

            $("#from-date-picker").val(null);
            $("#to-date-picker").val(null);

            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
        }

        function filterHistoryLogs(currentPage) {
            $("#result-table tbody tr").remove();
            $("#pagination-container").empty();
            $("#export-button").hide();

            var pageId = $("#page-picker").val();
            var ruleId = $("#rule-picker").val();
            var orderBy = $("#sort-by-picker").val();
            var fromDate = moment($("#from-date-picker").val()).startOf("day").valueOf();
            var toDate = moment($("#to-date-picker").val()).endOf("day").valueOf();

            if (fromDate > toDate) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-dla-history.filter.flags.warning.date-before")
                });
                return;
            }

            if (fromDate > moment().endOf("day").valueOf()) {
                flags.show({
                    type: "warning",
                    close: "auto",
                    body: AJS.I18n.getText("js-dla-history.filter.flags.warning.date-after")
                });
                return;
            }

            $("#progress-indicator").show();
            var page = currentPage ? currentPage : 1;
            var request = {
                page: page,
                pageId: pageId,
                ruleId: ruleId,
                orderBy: orderBy
            }

            if (fromDate) request.fromDate = fromDate;
            if (toDate) request.toDate = toDate

            //log.debug("filterEvents request = " + JSON.stringify(request));

            items = [];
            Rest.getFilteredDataRuleHistory(request,
                function (data) { // success
                    //log.debug("Filter.getIssues response = " + JSON.stringify(response));
                    if (typeof data === 'string') data = JSON.parse(data);

                    //log.debug("Rest.getFilteredAuditLogs currentPage = " + data.page + " ; totalPages = " + data.totalPages);
                    initPagination(data.page, data.totalPages);
                    data.items.forEach(function (event) {
                        items.push(event);
                    });

                    onSearchEnd();
                },
                function (error) { // error
                    log.error(error);
                    if (error.status == 400) {
                        flags.showFlag(AJS.I18n.getText("js-dla-history.filter.flags.warning.title.error-code") + " 400", error.responseText, "warning");
                    }
                    if (error.status == 403) {
                        flags.showFlag(AJS.I18n.getText("js-dla-history.filter.flags.warning.title.error-code") + " 403", error.responseText, "warning");
                    }

                    onSearchEnd();
                });
        }

        function onSearchEnd() {
            //log.debug("onSearchEnd items = " + JSON.stringify(items));
            $("#progress-indicator").hide();
            $("#export-button").show();

            items.forEach(function (item) {
                //log.debug("item= " + JSON.stringify(item));
                var wellFormatDate = moment(item.timeStamp).format("MMMM Do YYYY, h:mm:ss a");

                var affectedPages = [];
                if (item.pageIds) {
                    affectedPages = item.pageIds.split(",").map(function (item) {
                        return item.trim();
                    });
                }

                //log.debug("event.author = " + event.author);
                var tr = ACTONIC.GDPR.DLA.createHistoryTableRow({
                    id: item.id,
                    ruleName: item.ruleName,
                    details: item.details,
                    isLongDetails: item.details.length > 100,
                    date: wellFormatDate,
                    affectedPages: affectedPages,
                    isTooManyPages: affectedPages.length > 5,
                    resultCode: item.resultCode,
                    baseUrl: AJS.contextPath()
                });

                $("#result-table tbody").append(tr);
            });
        }

        function initPagination(currentPage, totalPages) {
            $("#pagination-container").empty();

            for (i = 1; i <= totalPages; i++) {
                var badge = $("<aui-badge/>").attr("data-page", i).text(i);
                if (currentPage == i) $(badge).addClass("aui-badge-primary");

                $("#pagination-container").append(badge);
            }

            $("#pagination-container aui-badge").off("click");
            $("#pagination-container aui-badge").on("click", function () {
                var pageNumber = $(this).attr("data-page");
                filterHistoryLogs(pageNumber);
            });
        }

        function initializeRulePicker(initialRuleId) {
            var parent = $("#rule-picker").parent();
            $("#rule-picker").remove();
            $("#s2id_rule-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select\" id=\"rule-picker\">");

            AJS.$("#rule-picker").auiSelect2({
                placeholder: AJS.I18n.getText("js-dla-history.placeholder.select-rule"),
                allowClear: true,
                ajax: {
                    type: "GET",
                    cache: true,
                    dataType: "json",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-level-agreement",
                    results: function (data) {
                        var results = [];
                        $.each(data, function (index, item) {
                            results.push({id: item.id, text: item.name});
                        });
                        return {
                            results: results
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (initialRuleId) {
                        Rest.getRule(initialRuleId,
                            function (data) { // success
                                // log.debug("Rest.getRule data = " + JSON.stringify(data));
                                if (data) callback({id: data.id, text: data.name});
                            },
                            function (error) {
                                log.error("Rest.getRule error = " + JSON.stringify(error));
                            });
                    }
                }
            });

            $("#rule-picker").off("change");
            $("#rule-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#page-picker").attr('disabled', 'disabled');
                    $("#page-picker").addClass("disabled-picker");
                }
            });

            if (initialRuleId) {
                $("#rule-picker").auiSelect2('val', initialRuleId).trigger("change");
            }
        }

        function initializeTicketPicker() {
            $("#page-picker").removeAttr('disabled');
            $("#page-picker").removeClass('disabled-picker');
            $("#page-picker").val('');

            $("#page-picker").off("change");
            $("#page-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#rule-picker").select2("disable");
                    $("#s2id_rule-picker a.select2-choice").addClass("disabled-picker");
                }
            });
        }
    }

    return new Filter();
});