/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.servlet;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ResourceServlet
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Calendar inOneMonth = Calendar.getInstance();
            inOneMonth.add(1, 1);
            resp.setDateHeader("Expires", inOneMonth.getTimeInMillis());
            String requestURI = req.getRequestURI();
            String path = "/actonic-gdpr-resources/front" + URLDecoder.decode(requestURI.replaceFirst(req.getContextPath() + "/plugins/servlet/actonic-gdpr/resources/download", ""), "UTF-8");
            ServletContext sc = this.getServletContext();
            String mimeType = sc.getMimeType(path);
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mimeType})) {
                mimeType = "text/html";
            }
            resp.setContentType(mimeType);
            if (!StringUtils.containsIgnoreCase((CharSequence)mimeType, (CharSequence)"image/png")) {
                this.writeFile(path, (OutputStream)resp.getOutputStream());
            } else {
                String[] parts = mimeType.split("/");
                this.writeImage(path, parts[1], (OutputStream)resp.getOutputStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String stacktrace = ExceptionUtils.getStackTrace((Throwable)e);
            try {
                resp.sendError(500, stacktrace);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                resp.setStatus(500);
            }
        }
    }

    private void writeFile(String pathToResource, OutputStream out) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(pathToResource);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
    }

    private void writeImage(String pathToResource, String imageFormat, OutputStream out) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(pathToResource);
        BufferedImage image = ImageIO.read(in);
        ImageIO.write((RenderedImage)image, imageFormat, out);
    }
}

