/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.manager;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceUserNameConvertManager {
    private static final String UNDEFINED_USER = "[undefined]";
    private static final String ANONYMOUS_USER = "[anonymous]";
    private final UserAccessor userAccessor;

    public ConfluenceUserNameConvertManager(@ComponentImport UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public String convertUserNameToUserKey(String userName) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userName})) {
            return ANONYMOUS_USER;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            return UNDEFINED_USER;
        }
        return user.getKey().getStringValue();
    }
}

