/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.confluence.gdpr.component.manager.CronManager;
import de.actonic.confluence.gdpr.component.service.DataRuleHistoryService;
import de.actonic.confluence.gdpr.component.service.DataRuleService;
import de.actonic.confluence.gdpr.model.DataRuleHistoryModel;
import de.actonic.confluence.gdpr.model.DataRuleModel;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/data-level-agreement")
@Produces(value={"application/json"})
public class DataRuleRest {
    private static final Logger log = LoggerFactory.getLogger(DataRuleRest.class);
    private final GDPRSettingsManager GDPRSettingsManager;
    private final DataRuleService dataRuleService;
    private final DataRuleHistoryService dataRuleHistoryService;
    private final CronManager cronManager;
    private final CqlManager cqlManager;
    @ComponentImport
    private final UserAccessor userManager;
    private final IGDPRUserManager gdprUserManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public DataRuleRest(GDPRSettingsManager GDPRSettingsManager2, DataRuleService dataRuleService, DataRuleHistoryService dataRuleHistoryService, CronManager cronManager, CqlManager cqlManager, UserAccessor userManager, IGDPRUserManager gdprUserManager, I18nResolver i18n) {
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.dataRuleService = dataRuleService;
        this.dataRuleHistoryService = dataRuleHistoryService;
        this.cronManager = cronManager;
        this.cqlManager = cqlManager;
        this.userManager = userManager;
        this.gdprUserManager = gdprUserManager;
        this.i18n = i18n;
    }

    private static String generateExportFileName() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy-HH.mm.ss");
        Date today = Calendar.getInstance().getTime();
        String reportDate = df.format(today);
        return "export-" + reportDate;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getAllRules() {
        try {
            List<DataRuleModel> items = this.dataRuleService.getItems();
            return Response.ok((Object)new Gson().toJson(items)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getDataRulesConfigurationStatus() {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            String serviceUserKey = this.GDPRSettingsManager.getRunTasksFromUser();
            if (Strings.isNullOrEmpty((String)serviceUserKey)) {
                return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"error", (Object)"message", (Object)this.i18n.getText("soy-data-rule.rest.service-user-key.empty.error")))).build();
            }
            ConfluenceUser applicationUser = this.userManager.getUserByKey(new UserKey(serviceUserKey));
            if (applicationUser == null) {
                return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"error", (Object)"message", (Object)(this.i18n.getText("soy-data-rule.rest.application-user.null.error") + " " + serviceUserKey)))).build();
            }
            return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"ok", (Object)"message", (Object)""))).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{id}/run")
    @Produces(value={"application/json"})
    public Response run(@PathParam(value="id") int id) {
        try {
            DataRuleHistoryModel dataRuleHistoryModel = this.dataRuleService.runDataRule(id);
            return Response.ok((Object)new Gson().toJson((Object)dataRuleHistoryModel)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.noContent().build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getRule(@PathParam(value="id") int id) {
        try {
            DataRuleModel item = this.dataRuleService.getItem(id);
            return Response.ok((Object)new Gson().toJson((Object)item)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteRule(@PathParam(value="id") int id) {
        try {
            this.dataRuleService.deleteItem(id);
            return Response.ok().build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response createRule(@FormParam(value="enabled") Boolean enabled, @FormParam(value="name") String name, @FormParam(value="cron") String cron, @FormParam(value="cql") String cql, @FormParam(value="type") String type, @FormParam(value="notificationType") String notificationType, @FormParam(value="parameters") String parameters, @FormParam(value="notificationParameters") String notificationParameters) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            DataRuleModel item = this.dataRuleService.createItem(applicationUser, enabled, name, cron, cql, type, parameters, notificationType, notificationParameters);
            return Response.ok((Object)new Gson().toJson((Object)item)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRule(@FormParam(value="enabled") Boolean enabled, @PathParam(value="id") int id, @FormParam(value="name") String name, @FormParam(value="cron") String cron, @FormParam(value="cql") String cql, @FormParam(value="type") String type, @FormParam(value="notificationType") String notificationType, @FormParam(value="parameters") String parameters, @FormParam(value="notificationParameters") String notificationParameters) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            DataRuleModel item = this.dataRuleService.updateItem(id, applicationUser, enabled, name, cron, cql, type, parameters, notificationType, notificationParameters);
            return Response.ok((Object)new Gson().toJson((Object)item)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/toggle")
    @Produces(value={"application/json"})
    public Response toggleRule(@PathParam(value="id") int id) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            DataRuleModel item = this.dataRuleService.toggleItem(id, applicationUser);
            return Response.ok((Object)new Gson().toJson((Object)item)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/{id}/clone")
    @Produces(value={"application/json"})
    public Response cloneRule(@PathParam(value="id") int id) {
        try {
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            DataRuleModel item = this.dataRuleService.cloneItem(id, applicationUser);
            return Response.ok((Object)new Gson().toJson((Object)item)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/cron")
    @Produces(value={"application/json"})
    public Response checkCron(@FormParam(value="cron") String cron) {
        boolean isValid = this.cronManager.isCronValid(cron) && this.cronManager.isCronDurationValid(cron);
        return Response.ok((Object)new Gson().toJson((Object)isValid)).build();
    }

    @POST
    @Path(value="/cql")
    @Produces(value={"application/json"})
    public Response checkCql(@FormParam(value="cql") String cql) {
        Optional<String> cqlValidationStatusModel = this.cqlManager.isCqlValid(cql);
        return Response.ok((Object)new Gson().toJson(cqlValidationStatusModel)).build();
    }

    @POST
    @Path(value="/filter")
    public Response filterEvents(@FormParam(value="page") Integer page, @FormParam(value="pageId") String pageId, @FormParam(value="ruleId") int ruleId, @FormParam(value="fromDate") long fromDate, @FormParam(value="toDate") long toDate, @FormParam(value="orderBy") String orderBy) {
        try {
            int end;
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            List<DataRuleHistoryModel> ruleHistoryModels = this.filterResults(ruleId, pageId, fromDate, toDate, orderBy);
            if (page == null) {
                page = 0;
            }
            int offset = this.GDPRSettingsManager.getRowsPerPage();
            int start = (page - 1) * offset;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + offset) > ruleHistoryModels.size()) {
                end = ruleHistoryModels.size();
            }
            int totalPages = (int)Math.ceil((double)ruleHistoryModels.size() / (double)offset);
            ruleHistoryModels = ruleHistoryModels.subList(start, end);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("items", ruleHistoryModels);
            resultMap.put("totalPages", totalPages);
            resultMap.put("page", page);
            return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    private List<DataRuleHistoryModel> filterResults(int ruleId, String pageId, long fromDate, long toDate, String orderBy) {
        List<Object> announcingHistoryModels = new ArrayList();
        if (ruleId != 0) {
            announcingHistoryModels = this.dataRuleHistoryService.filterItemsByRule(ruleId, fromDate, toDate);
        }
        if (!Strings.isNullOrEmpty((String)pageId)) {
            announcingHistoryModels = this.dataRuleHistoryService.filterItemsByPageId(pageId, fromDate, toDate);
        }
        if (ruleId == 0 && Strings.isNullOrEmpty((String)pageId)) {
            announcingHistoryModels = this.dataRuleHistoryService.getHistoryItems(fromDate, toDate);
        }
        this.dataRuleHistoryService.sortEvents(announcingHistoryModels, orderBy);
        return announcingHistoryModels;
    }

    @GET
    @Path(value="/export")
    @Produces(value={"text/plain"})
    public Response export(@QueryParam(value="pageId") String pageId, @QueryParam(value="ruleId") int ruleId, @QueryParam(value="fromDate") long fromDate, @QueryParam(value="toDate") long toDate, @QueryParam(value="orderBy") String orderBy) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            List<DataRuleHistoryModel> ruleHistoryModels = this.filterResults(ruleId, pageId, fromDate, toDate, orderBy);
            String fileName = DataRuleRest.generateExportFileName();
            File file = File.createTempFile(fileName, "csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Date", "Rule Name", "Result", "Details", "Affected Issues"}).withDelimiter(';');
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            ruleHistoryModels.forEach(ruleHistoryModel -> {
                try {
                    csvFilePrinter.printRecord(new Object[]{ruleHistoryModel.getTimeStamp(), ruleHistoryModel.getRuleName(), this.convertResult(ruleHistoryModel.getResultCode()), ruleHistoryModel.getDetails(), ruleHistoryModel.getPageIds()});
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    private String convertResult(int code) {
        String result = null;
        switch (code) {
            case 0: {
                result = "Completed successfully";
                break;
            }
            case 1: {
                result = "Completed with some errors";
                break;
            }
            case 2: {
                result = "Error. Cannot be executed";
            }
        }
        return result;
    }
}

