/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DCCommentAuthorChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(DCCommentAuthorChanger.class);
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final CommentManager commentManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    @Autowired
    public DCCommentAuthorChanger(PageManager pageManager, CommentManager commentManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate) {
        this.commentManager = commentManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
    }

    @Override
    public String getType() {
        return "user";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            HashSet<String> resultList = new HashSet<String>();
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                ConfluenceUser confluenceUser = comment.getCreator();
                if (confluenceUser == null) continue;
                resultList.add(confluenceUser.getKey().toString());
            }
            return Lists.newArrayList(resultList);
        });
    }

    @Override
    public void applyNewValues(Long pageId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(pageId.longValue());
            List comments = ceo.getComments();
            for (Comment comment : comments) {
                this.transactionTemplate.execute(() -> {
                    String authorKey;
                    Comment changedComment = this.commentManager.getComment(comment.getId());
                    String string = authorKey = changedComment.getCreator() != null ? changedComment.getCreator().getKey().toString() : "";
                    if (!Strings.isNullOrEmpty((String)authorKey)) {
                        for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                            if (!authorKey.equals(entry.getKey())) continue;
                            ConfluenceUser sourceAuthor = this.userAccessor.getUserByKey(new UserKey((String)entry.getValue()));
                            changedComment.setCreator(sourceAuthor);
                            this.commentManager.saveContentEntity((ContentEntityObject)changedComment, this.SAVE_CONTEXT);
                        }
                    }
                    return true;
                });
            }
            return true;
        });
    }
}

