/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.audit.api.AuditQuery;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.actonic.confluence.gdpr.model.EventModel;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PermissionMonitoringService {
    private static final Logger log = LoggerFactory.getLogger(PermissionMonitoringService.class);
    private final UserAccessor userManager;
    private final GroupManager groupManager;
    private final AuditService auditService;
    private final SpaceManager spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final CQLSearchService cqlSearchService;
    private final String baseUrl;
    private final AuditSearchService auditSearchService;
    @ComponentImport
    private final I18nResolver i18n;
    private final List<AuditRecordCategoryType> allowedEventCategories = Lists.newArrayList((Object[])new AuditRecordCategoryType[]{AuditRecordCategoryType.UsersAndGroups, AuditRecordCategoryType.Permissions, AuditRecordCategoryType.Spaces});

    @Autowired
    public PermissionMonitoringService(@ComponentImport UserAccessor userManager, @ComponentImport GroupManager groupManager, @ComponentImport @Qualifier(value="auditService") AuditService auditService, @ComponentImport SpaceManager spaceManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport CQLSearchService cqlSearchService, @ComponentImport AuditSearchService auditSearchService, I18nResolver i18n) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.auditService = auditService;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.cqlSearchService = cqlSearchService;
        this.auditSearchService = auditSearchService;
        this.i18n = i18n;
    }

    private Optional<User> getUserFromCachedMapByNames(String userNameAsString, Map<String, User> userNameToObjectMap) {
        User currentUser;
        if (userNameToObjectMap.containsKey(userNameAsString)) {
            currentUser = userNameToObjectMap.get(userNameAsString);
        } else {
            currentUser = this.userManager.getUserByName(userNameAsString);
            userNameToObjectMap.put(userNameAsString, currentUser);
        }
        return currentUser == null ? Optional.empty() : Optional.of(currentUser);
    }

    private Optional<User> getUserFromCachedMapByIds(String userNameAsString, Map<String, User> userNameToObjectMap) {
        User currentUser;
        if (userNameToObjectMap.containsKey(userNameAsString)) {
            currentUser = userNameToObjectMap.get(userNameAsString);
        } else {
            currentUser = this.userManager.getUserByKey(new UserKey(userNameAsString));
            userNameToObjectMap.put(userNameAsString, currentUser);
        }
        return currentUser == null ? Optional.empty() : Optional.of(currentUser);
    }

    private Optional<Group> getGroupFromCachedMap(String groupNameAsString, Map<String, Group> groupNameToObjectMap) {
        if (groupNameToObjectMap.containsKey(groupNameAsString)) {
            return Optional.of(groupNameToObjectMap.get(groupNameAsString));
        }
        try {
            Group group = this.groupManager.getGroup(groupNameAsString);
            if (group != null) {
                groupNameToObjectMap.put(groupNameAsString, group);
                return Optional.of(group);
            }
        }
        catch (EntityException entityException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private String getFormattedUserIds(String userNameString, String format, Map<String, User> userNameToObjectMap) {
        if (Strings.isNullOrEmpty((String)userNameString)) {
            return "";
        }
        if (userNameString.contains(",")) {
            ArrayList userNamesList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)userNameString));
            return userNamesList.stream().map(userName -> {
                Optional<User> user = this.getUserFromCachedMapByIds((String)userName, userNameToObjectMap);
                return this.formatUser(user, (String)userName, format);
            }).collect(Collectors.joining(", "));
        }
        Optional<User> user = this.getUserFromCachedMapByIds(userNameString, userNameToObjectMap);
        return this.formatUser(user, userNameString, format);
    }

    private String getFormattedUserNames(String userNameString, String format, Map<String, User> userNameToObjectMap) {
        if (Strings.isNullOrEmpty((String)userNameString)) {
            return "";
        }
        if (userNameString.contains(",")) {
            ArrayList userNamesList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)userNameString));
            return userNamesList.stream().map(userName -> {
                Optional<User> user = this.getUserFromCachedMapByNames((String)userName, userNameToObjectMap);
                return this.formatUser(user, (String)userName, format);
            }).collect(Collectors.joining(", "));
        }
        Optional<User> user = this.getUserFromCachedMapByNames(userNameString, userNameToObjectMap);
        return this.formatUser(user, userNameString, format);
    }

    private String formatUser(Optional<User> optionalUser, String historicalUserName, String outputFormat) {
        if (historicalUserName == null || StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)historicalUserName) || StringUtils.equalsIgnoreCase((CharSequence)"anonymous", (CharSequence)historicalUserName)) {
            return "Anonymous";
        }
        if (!optionalUser.isPresent()) {
            return "Unknown user '" + historicalUserName + "'";
        }
        User user = optionalUser.get();
        if ("html".equals(outputFormat)) {
            return "<a target='_blank' href='" + this.baseUrl + "/users/viewuserprofile.action?username=" + user.getName() + "'>" + user.getFullName() + "</a>";
        }
        if ("csv".equals(outputFormat)) {
            return user.getFullName();
        }
        return user.getName();
    }

    private String getFormattedGroupNames(String groupNameString, String outputFormat, Map<String, Group> groupNameObjectMap) {
        if (Strings.isNullOrEmpty((String)groupNameString)) {
            return "";
        }
        if (groupNameString.contains(",")) {
            String result = "";
            ArrayList groupNamesList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)groupNameString));
            for (String groupName : groupNamesList) {
                Optional<Group> optionalGroup = this.getGroupFromCachedMap(groupName, groupNameObjectMap);
                result = result + this.formatGroup(optionalGroup, groupName, outputFormat) + ", ";
            }
            return result;
        }
        Optional<Group> optionalGroup = this.getGroupFromCachedMap(groupNameString, groupNameObjectMap);
        return this.formatGroup(optionalGroup, groupNameString, outputFormat);
    }

    private String formatGroup(Optional<Group> optionalGroup, String historicalGroupName, String outputFormat) {
        if (!optionalGroup.isPresent()) {
            return "Unknown group '" + historicalGroupName + "'";
        }
        if ("html".equals(outputFormat)) {
            return "<a target='_blank' href='" + this.baseUrl + "/admin/users/domembersofgroupsearch.action?membersOfGroupTerm=" + historicalGroupName + "'>" + historicalGroupName + "</a>";
        }
        if ("csv".equals(outputFormat)) {
            return historicalGroupName;
        }
        return historicalGroupName;
    }

    private String getFormattedSpaceByNames(List<String> spaceKeyNames, String outputFormat, Map<String, Space> spaceNameObjectMap) {
        String result = "";
        for (String spaceName : spaceKeyNames) {
            Optional<Space> optionalSpace = this.getSpaceByName(spaceName, spaceNameObjectMap);
            result = result + this.formatSpace(optionalSpace, spaceName, outputFormat);
        }
        return result;
    }

    private String getFormattedSpaceByNames(String spaceKeyNames, String outputFormat, Map<String, Space> spaceNameObjectMap) {
        if (Strings.isNullOrEmpty((String)spaceKeyNames)) {
            return "";
        }
        if (spaceKeyNames.contains(",")) {
            ArrayList spaceNames = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)spaceKeyNames));
            return this.getFormattedSpaceByNames(spaceNames, outputFormat, spaceNameObjectMap);
        }
        Optional<Space> optionalSpace = this.getSpaceByName(spaceKeyNames, spaceNameObjectMap);
        return this.formatSpace(optionalSpace, spaceKeyNames, outputFormat);
    }

    private String getFormattedSpaceByKey(String splittedSpaceKeys, String outputFormat, Map<String, Space> spaceNameObjectMap) {
        if (Strings.isNullOrEmpty((String)splittedSpaceKeys)) {
            return "";
        }
        if (splittedSpaceKeys.contains(",")) {
            String result = "";
            ArrayList spaceNames = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)splittedSpaceKeys));
            for (String spaceName : spaceNames) {
                Optional<Space> optionalSpace = this.getSpaceByKey(spaceName, spaceNameObjectMap);
                result = result + this.formatSpace(optionalSpace, spaceName, outputFormat) + ", ";
            }
            return result;
        }
        Optional<Space> optionalSpace = this.getSpaceByKey(splittedSpaceKeys, spaceNameObjectMap);
        return this.formatSpace(optionalSpace, splittedSpaceKeys, outputFormat);
    }

    private String formatSpace(Optional<Space> optionalSpace, String probablyKey, String outputFormat) {
        if (!optionalSpace.isPresent()) {
            return "Unknown space '" + probablyKey + "'";
        }
        Space space = optionalSpace.get();
        if ("html".equals(outputFormat)) {
            return "<a target='_blank' href='" + this.baseUrl + "/display/" + space.getKey() + "'>" + space.getName() + "</a>";
        }
        if ("csv".equals(outputFormat)) {
            return space.getName();
        }
        return space.getKey();
    }

    public void sortEvents(List<EventModel> eventModels, String sortBy) {
        if ("dateAsc".equals(sortBy)) {
            Collections.sort(eventModels, Comparator.comparing(EventModel::getDate));
        }
        if ("dateDesc".equals(sortBy)) {
            Collections.sort(eventModels, Comparator.comparing(EventModel::getDate).reversed());
        }
        if ("user".equals(sortBy)) {
            Collections.sort(eventModels, Comparator.comparing(EventModel::getUserName));
        }
        if ("eventType".equals(sortBy)) {
            Collections.sort(eventModels, Comparator.comparing(EventModel::getSummary));
        }
    }

    private Optional<Space> getSpaceByKey(String spaceKey, Map<String, Space> spaceNameObjectMap) {
        Optional<Space> optionalSpace = Optional.empty();
        if (spaceNameObjectMap.containsKey(spaceKey)) {
            return Optional.of(spaceNameObjectMap.get(spaceKey));
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            spaceNameObjectMap.put(spaceKey, space);
            return Optional.of(space);
        }
        return optionalSpace;
    }

    private List<String> getSpaceKeysByName(String splittedSpaceNames, Map<String, Space> spaceNameObjectMap) {
        ArrayList spaceKeys = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)splittedSpaceNames)) {
            if (splittedSpaceNames.contains(",")) {
                ArrayList spaceNames = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)splittedSpaceNames));
                for (String spaceName : spaceNames) {
                    Optional<Space> optionalSpace = this.getSpaceByName(spaceName, spaceNameObjectMap);
                    optionalSpace.ifPresent(space -> spaceKeys.add(space.getKey()));
                }
            } else {
                Optional<Space> optionalSpace = this.getSpaceByName(splittedSpaceNames, spaceNameObjectMap);
                optionalSpace.ifPresent(space -> spaceKeys.add(space.getKey()));
            }
        }
        return spaceKeys;
    }

    private Optional<Space> getSpaceByName(String spaceName, Map<String, Space> spaceNameObjectMap) {
        Optional<Space> optionalSpace = Optional.empty();
        if (spaceNameObjectMap.containsKey(spaceName)) {
            return Optional.of(spaceNameObjectMap.get(spaceName));
        }
        SimplePageRequest pageRequest = new SimplePageRequest(0, 1);
        try {
            SearchPageResponse contents = this.cqlSearchService.search("siteSearch ~ \"" + spaceName + "\" AND type = \"space\"", SearchOptions.buildDefault(), (PageRequest)pageRequest, new Expansion[0]);
            if (contents.size() > 0) {
                for (SearchResult searchResult : contents.getResults()) {
                    Space space;
                    com.atlassian.confluence.api.model.content.Space searchResultEntitySpace = (com.atlassian.confluence.api.model.content.Space)searchResult.getEntity();
                    if (searchResultEntitySpace == null || (space = this.spaceManager.getSpace(searchResultEntitySpace.getKey())) == null) continue;
                    spaceNameObjectMap.put(spaceName, space);
                    return Optional.of(space);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return optionalSpace;
    }

    private Set<String> getGroupNamesForUsers(Set<String> userNames) {
        HashSet groupNamesForUsers = Sets.newHashSet();
        for (String userName : userNames) {
            ConfluenceUser confluenceUser = this.userManager.getUserByName(userName);
            if (confluenceUser == null) continue;
            try {
                List groups = PagerUtils.toList((Pager)this.groupManager.getGroups((User)confluenceUser));
                for (Group group : groups) {
                    groupNamesForUsers.add(group.getName());
                }
            }
            catch (EntityException e) {
                e.printStackTrace();
            }
        }
        return groupNamesForUsers;
    }

    private List<String> getUserNamesFromGroup(String groupNameToSearch) {
        try {
            Group group = this.groupManager.getGroup(groupNameToSearch);
            if (group != null) {
                return PagerUtils.toList((Pager)this.groupManager.getMemberNames(group));
            }
            return Lists.newArrayList();
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    private String getChangeValue(List<ChangedValue> changedValues, String fieldName, boolean getNew) {
        try {
            ChangedValue resultChangedValue = changedValues.stream().filter(changedValue -> changedValue.getKey().equals(fieldName)).findFirst().get();
            return getNew ? resultChangedValue.getTo() : resultChangedValue.getFrom();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getAssociatedObjectByType(List<AuditResource> associatedObjects, String objectType) {
        try {
            AuditResource resultAssociatedObject = associatedObjects.stream().filter(associatedObject -> associatedObject.getType().equals(objectType)).findFirst().get();
            return resultAssociatedObject.getName();
        }
        catch (Exception e) {
            return "";
        }
    }

    private AuditRecordCategoryType getAuditRecordCategoryFromString(String categoryAsString) {
        if ("ALL".equals(categoryAsString)) {
            return AuditRecordCategoryType.All;
        }
        if ("Permissions".equals(categoryAsString)) {
            return AuditRecordCategoryType.Permissions;
        }
        if ("Users and groups".equals(categoryAsString)) {
            return AuditRecordCategoryType.UsersAndGroups;
        }
        if ("Spaces".equals(categoryAsString)) {
            return AuditRecordCategoryType.Spaces;
        }
        return AuditRecordCategoryType.Other;
    }

    private boolean isAllowedAuditCategories(AuditRecordCategoryType auditRecordCategoryType) {
        return auditRecordCategoryType == AuditRecordCategoryType.Permissions || auditRecordCategoryType == AuditRecordCategoryType.Spaces || auditRecordCategoryType == AuditRecordCategoryType.UsersAndGroups;
    }

    private ConfluenceUser getConfluenceUserFromAudit(AuditAuthor auditAuthor) {
        String authorName = auditAuthor.getName();
        String authorKey = auditAuthor.getId();
        ConfluenceUserImpl user = StringUtils.equals((CharSequence)"Anonymous", (CharSequence)authorName) ? new ConfluenceUserImpl("anonymous", "Anonymous", "anonymous@noemail") : (StringUtils.isBlank((CharSequence)authorKey) ? new ConfluenceUserImpl("Unknown user 'authorName'", authorName, "unknown@noemail") : this.userManager.getUserByKey(new UserKey(authorKey)));
        return user;
    }

    public Map filterHistoricalEventsV2(String outputFormat, String eventTypeToSearch, String userNameToSearch, String groupNameToSearch, String spaceKeyToSearch, Long fromDate, Long toDate, String orderBy) {
        Instant instantFrom = fromDate == null ? Instant.ofEpochMilli(0L) : Instant.ofEpochMilli(fromDate);
        Instant instantTo = toDate == null ? Instant.ofEpochMilli(new Date().getTime()) : Instant.ofEpochMilli(toDate);
        boolean isSearchByUser = !Strings.isNullOrEmpty((String)userNameToSearch);
        boolean isSearchByGroup = !Strings.isNullOrEmpty((String)groupNameToSearch);
        boolean isSearchBySpace = !Strings.isNullOrEmpty((String)spaceKeyToSearch);
        HashSet userNames = Sets.newHashSet();
        HashSet groupNames = Sets.newHashSet();
        if (isSearchByUser) {
            userNames.add(userNameToSearch);
            groupNames.addAll(this.getGroupNamesForUsers((Set<String>)ImmutableSet.of((Object)userNameToSearch)));
        }
        if (isSearchByGroup) {
            userNames.addAll(this.getUserNamesFromGroup(groupNameToSearch));
            groupNames.add(groupNameToSearch);
        }
        ConfluenceUser userToSearchObj = this.userManager.getUserByName(userNameToSearch);
        AuditRecordCategoryType eventTypeToSearchCategory = this.getAuditRecordCategoryFromString(eventTypeToSearch);
        AuditQuery auditQuery = this.buildQuery(eventTypeToSearch, instantFrom, instantTo);
        Date timeoutStartDate = new Date();
        ArrayList eventResultList = Lists.newArrayList();
        log.debug("Start searching audit log data...");
        log.debug(String.format("isSearchByUser ?= %s, isSearchByGroup ?= %s, isSearchBySpace ?= %s", isSearchByUser, isSearchByGroup, isSearchBySpace));
        HashMap spaceNameObjectMap = Maps.newHashMap();
        HashMap userNameObjectMap = Maps.newHashMap();
        HashMap groupNameObjectMap = Maps.newHashMap();
        try {
            Page auditEntityCursorPage = this.auditSearchService.findBy(auditQuery, new PageRequest.Builder().offset(0).limit(1000).build());
            while (auditEntityCursorPage != null) {
                if ((new Date().getTime() - timeoutStartDate.getTime()) / 1000L > 60L) {
                    throw new TimeoutException("Timeout exception");
                }
                for (AuditEntity auditEntity : auditEntityCursorPage.getValues()) {
                    log.debug(auditEntity.toString());
                    String auditRecordCategoryAsString = auditEntity.getAuditType().getCategory();
                    AuditRecordCategoryType auditRecordCategoryType = this.getAuditRecordCategoryFromString(auditRecordCategoryAsString);
                    if ((eventTypeToSearchCategory != AuditRecordCategoryType.All || !this.isAllowedAuditCategories(auditRecordCategoryType)) && eventTypeToSearchCategory != auditRecordCategoryType) continue;
                    ConfluenceUser author = this.getConfluenceUserFromAudit(auditEntity.getAuthor());
                    String action = auditEntity.getAuditType().getAction();
                    String affectedUsers = auditEntity.getAffectedObjects().stream().filter(e -> StringUtils.equals((CharSequence)"User", (CharSequence)e.getType())).map(AuditResource::getId).filter(StringUtils::isNotBlank).map(key -> this.userManager.getUserByKey(new UserKey(key))).filter(Objects::nonNull).map(Principal::getName).collect(Collectors.joining(","));
                    String affectedGroup = auditEntity.getAffectedObjects().stream().filter(e -> StringUtils.equals((CharSequence)"Group", (CharSequence)e.getType())).map(AuditResource::getId).collect(Collectors.joining(","));
                    String affectedSpace = auditEntity.getAffectedObjects().stream().filter(e -> StringUtils.equals((CharSequence)"Space", (CharSequence)e.getType())).map(AuditResource::getName).collect(Collectors.joining(","));
                    if (!this.isContainAffectedObject(userNames, affectedUsers) && !this.isContainAffectedObject(groupNames, affectedGroup) && !isSearchBySpace) continue;
                    String detailsField = "";
                    if (isSearchBySpace) {
                        if (auditRecordCategoryType == AuditRecordCategoryType.Spaces) {
                            String currentSpaceKey = this.getChangeValue(auditEntity.getChangedValues(), "Space key", true);
                            if (!StringUtils.equals((CharSequence)spaceKeyToSearch, (CharSequence)currentSpaceKey)) continue;
                            detailsField = this.getFormattedSpaceByKey(currentSpaceKey, outputFormat, spaceNameObjectMap);
                        } else {
                            List<String> affectedSpaceKeys = this.getSpaceKeysByName(affectedSpace, spaceNameObjectMap);
                            if (!affectedSpaceKeys.contains(spaceKeyToSearch)) continue;
                            detailsField = this.getFormattedSpaceByNames(affectedSpaceKeys, outputFormat, (Map<String, Space>)spaceNameObjectMap);
                        }
                    }
                    String summaryField = auditRecordCategoryAsString + ": " + action;
                    String resultUserNameField = "";
                    String formattedUsers = this.getFormattedUserNames(affectedUsers, outputFormat, userNameObjectMap);
                    String formattedGroups = this.getFormattedGroupNames(affectedGroup, outputFormat, groupNameObjectMap);
                    if (!formattedUsers.isEmpty()) {
                        resultUserNameField = resultUserNameField + formattedUsers;
                    }
                    if (!formattedUsers.isEmpty() && !formattedGroups.isEmpty()) {
                        resultUserNameField = resultUserNameField + ", ";
                    }
                    if (!formattedGroups.isEmpty()) {
                        resultUserNameField = resultUserNameField + formattedGroups;
                    }
                    if (isSearchByUser) {
                        ArrayList splittedUserNames = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)affectedUsers));
                        if (userToSearchObj == null || !splittedUserNames.isEmpty() && !splittedUserNames.contains(userToSearchObj.getName())) continue;
                    }
                    if (auditRecordCategoryType == AuditRecordCategoryType.Permissions) {
                        String formattedSpace;
                        String oldPermission = this.getChangeValue(auditEntity.getChangedValues(), "Type", false);
                        String newPermission = this.getChangeValue(auditEntity.getChangedValues(), "Type", true);
                        String object = "";
                        if (!Strings.isNullOrEmpty((String)oldPermission)) {
                            object = "Removed permission " + oldPermission;
                        }
                        if (!Strings.isNullOrEmpty((String)newPermission)) {
                            object = "Added permission " + newPermission;
                        }
                        if (!(formattedSpace = this.getFormattedSpaceByNames(affectedSpace, outputFormat, (Map<String, Space>)spaceNameObjectMap)).isEmpty()) {
                            formattedSpace = formattedSpace + ": ";
                        }
                        detailsField = formattedSpace + object;
                    }
                    if (auditRecordCategoryType == AuditRecordCategoryType.UsersAndGroups) {
                        String formatedGroupNames;
                        String formatedUserNames = this.getFormattedUserNames(affectedUsers, outputFormat, userNameObjectMap);
                        if (!formatedUserNames.isEmpty()) {
                            formatedUserNames = "Users: " + formatedUserNames;
                        }
                        if (!(formatedGroupNames = this.getFormattedGroupNames(affectedGroup, outputFormat, groupNameObjectMap)).isEmpty()) {
                            formatedGroupNames = "Groups: " + formatedGroupNames;
                        }
                        if (!formatedUserNames.isEmpty() && !formatedGroupNames.isEmpty()) {
                            formatedGroupNames = " >> " + formatedGroupNames;
                        }
                        detailsField = formatedUserNames + formatedGroupNames;
                    }
                    eventResultList.add(EventModel.builder().date(Date.from(auditEntity.getTimestamp())).author(this.getFormattedUserNames(author.getName(), outputFormat, userNameObjectMap)).type(auditRecordCategoryAsString).userName(resultUserNameField).summary(summaryField).details(detailsField).build());
                }
                auditEntityCursorPage = auditEntityCursorPage.getNextPageRequest().isPresent() ? this.auditSearchService.findBy(auditQuery, (com.atlassian.audit.api.util.pagination.PageRequest)auditEntityCursorPage.getNextPageRequest().get()) : null;
            }
        }
        catch (TimeoutException e2) {
            return ImmutableMap.of((Object)"results", (Object)eventResultList, (Object)"statusCode", (Object)1, (Object)"message", (Object)"Timeout exception");
        }
        return ImmutableMap.of((Object)"results", (Object)eventResultList, (Object)"statusCode", (Object)0);
    }

    public Map filterHistoricalEvents(String outputFormat, String eventTypeToSearch, String userNameToSearch, String groupNameToSearch, String spaceKeyToSearch, Long fromDate, Long toDate, String orderBy) {
        Stopwatch totalTaskWatcher = Stopwatch.createStarted();
        ArrayList eventResultList = Lists.newArrayList();
        Instant instantFrom = fromDate == null ? Instant.ofEpochMilli(0L) : Instant.ofEpochMilli(fromDate);
        Instant instantTo = toDate == null ? Instant.ofEpochMilli(new Date().getTime()) : Instant.ofEpochMilli(toDate);
        boolean isSearchByUser = !Strings.isNullOrEmpty((String)userNameToSearch) || !Strings.isNullOrEmpty((String)groupNameToSearch);
        boolean isSearchBySpace = !Strings.isNullOrEmpty((String)spaceKeyToSearch);
        HashSet userNames = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)userNameToSearch)) {
            userNames.add(userNameToSearch);
        }
        if (!Strings.isNullOrEmpty((String)groupNameToSearch)) {
            userNames.addAll(this.getUserNamesFromGroup(groupNameToSearch));
        }
        HashSet groupNames = Sets.newHashSet();
        if (userNames.size() > 0) {
            groupNames.addAll(this.getGroupNamesForUsers(userNames));
        }
        AuditService.AuditRecordFinder auditRecordFinder = this.auditService.getRecords(instantFrom, instantTo);
        HashMap spaceNameObjectMap = Maps.newHashMap();
        HashMap userNameObjectMap = Maps.newHashMap();
        HashMap groupNameObjectMap = Maps.newHashMap();
        AuditRecordCategoryType eventTypeToSearchCategory = this.getAuditRecordCategoryFromString(eventTypeToSearch);
        Date startDate = new Date();
        AuditQuery auditQuery = this.buildQuery(eventTypeToSearch, instantFrom, instantTo);
        try {
            Page auditEntityCursorPage = this.auditSearchService.findBy(auditQuery, new PageRequest.Builder().offset(0).limit(1000).build());
            while (auditEntityCursorPage != null) {
                long seconds = (new Date().getTime() - startDate.getTime()) / 1000L;
                if (seconds > 60L) {
                    throw new Exception("Timeout exception");
                }
                Stopwatch auditRecordWatcher = Stopwatch.createStarted();
                auditEntityCursorPage.getValues().forEach(auditEntity -> {
                    String details;
                    String auditRecordCategoryAsString = auditEntity.getAuditType().getCategory();
                    AuditRecordCategoryType auditRecordCategoryType = this.getAuditRecordCategoryFromString(auditRecordCategoryAsString);
                    String affectedObjectType = "";
                    String affectedObjectName = "";
                    for (AuditResource affectedObject : auditEntity.getAffectedObjects()) {
                        affectedObjectType = affectedObjectType + "," + affectedObject.getType();
                        if (StringUtils.equals((CharSequence)"Permissions", (CharSequence)auditEntity.getAuditType().getCategory()) && StringUtils.equals((CharSequence)"User", (CharSequence)affectedObject.getType())) {
                            String userKey = StringUtils.isNotBlank((CharSequence)affectedObject.getId()) ? affectedObject.getId() : "[undefined]";
                            ConfluenceUser affectedUser = this.userManager.getUserByKey(new UserKey(userKey));
                            affectedObjectName = affectedObjectName + (affectedUser != null ? affectedUser.getLowerName() : "userKey") + ", ";
                            continue;
                        }
                        affectedObjectName = affectedObjectName + affectedObject.getName() + ", ";
                    }
                    String authorName = auditEntity.getAuthor().getName();
                    if (auditRecordCategoryType == AuditRecordCategoryType.Permissions && (eventTypeToSearchCategory == AuditRecordCategoryType.All || eventTypeToSearchCategory == AuditRecordCategoryType.Permissions)) {
                        String subject = "";
                        if (affectedObjectType.contains("Group")) {
                            subject = this.getFormattedGroupNames(affectedObjectName, outputFormat, groupNameObjectMap);
                        }
                        if (affectedObjectType.contains("User")) {
                            subject = this.getFormattedUserNames(affectedObjectName, outputFormat, userNameObjectMap);
                        }
                        String oldPermission = this.getChangeValue(auditEntity.getChangedValues(), "Type", false);
                        String newPermission = this.getChangeValue(auditEntity.getChangedValues(), "Type", true);
                        String object = "";
                        if (!Strings.isNullOrEmpty((String)oldPermission)) {
                            object = "Removed permission " + oldPermission + " for ";
                        }
                        if (!Strings.isNullOrEmpty((String)newPermission)) {
                            object = "Added permission " + newPermission + " for ";
                        }
                        String historicalSpaceName = this.getAssociatedObjectByType(auditEntity.getAffectedObjects(), "Space");
                        String formatSpace = "";
                        Optional<Space> optionalSpace = Optional.empty();
                        if (!historicalSpaceName.isEmpty()) {
                            optionalSpace = this.getSpaceByName(historicalSpaceName, spaceNameObjectMap);
                            formatSpace = this.formatSpace(optionalSpace, historicalSpaceName, outputFormat) + ". ";
                        }
                        String details2 = formatSpace + object + subject;
                        if (isSearchByUser && affectedObjectType.contains("Group") && this.isContainAffectedObject(groupNames, affectedObjectName) || affectedObjectType.contains("User") && this.isContainAffectedObject(userNames, affectedObjectName) || userNames.contains(authorName)) {
                            eventResultList.add(new EventModel(Date.from(auditEntity.getTimestamp()), auditRecordCategoryAsString, this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), subject, auditEntity.getAuditType().getCategory(), details2));
                            return;
                        }
                        if (isSearchBySpace && optionalSpace.isPresent() && optionalSpace.get().getKey().equals(spaceKeyToSearch)) {
                            eventResultList.add(new EventModel(Date.from(auditEntity.getTimestamp()), auditRecordCategoryAsString, this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), subject, auditEntity.getAuditType().getCategory(), details2));
                            return;
                        }
                    }
                    if (auditRecordCategoryType == AuditRecordCategoryType.UsersAndGroups && (eventTypeToSearchCategory == AuditRecordCategoryType.All || eventTypeToSearchCategory == AuditRecordCategoryType.UsersAndGroups) && isSearchByUser && (affectedObjectType.contains("Group") && this.isContainAffectedObject(groupNames, affectedObjectName) || affectedObjectType.contains("User") && this.isContainAffectedObject(userNames, affectedObjectName) || userNames.contains(authorName))) {
                        details = "";
                        String subject = "";
                        String affectedUserNames = auditEntity.getAffectedObjects().stream().filter(obj -> obj.getType().equals("User")).map(AuditResource::getName).collect(Collectors.joining(", "));
                        String affectedGroupNames = auditEntity.getAffectedObjects().stream().filter(obj -> obj.getType().equals("Group")).map(AuditResource::getName).collect(Collectors.joining(", "));
                        if (affectedObjectType.contains("Group")) {
                            details = details + "User " + this.getFormattedUserNames(affectedUserNames, outputFormat, userNameObjectMap) + ". Group " + this.getFormattedGroupNames(affectedGroupNames, outputFormat, groupNameObjectMap);
                            subject = this.getFormattedGroupNames(affectedGroupNames, outputFormat, groupNameObjectMap);
                        } else if (affectedObjectType.contains("User")) {
                            details = details + "User " + this.getFormattedUserNames(affectedUserNames, outputFormat, userNameObjectMap);
                            subject = this.getFormattedUserNames(affectedUserNames, outputFormat, userNameObjectMap);
                        }
                        eventResultList.add(new EventModel(Date.from(auditEntity.getTimestamp()), auditRecordCategoryAsString, this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), subject, auditEntity.getAuditType().getCategory(), details));
                        return;
                    }
                    if (auditRecordCategoryType == AuditRecordCategoryType.Spaces && (eventTypeToSearchCategory == AuditRecordCategoryType.All || eventTypeToSearchCategory == AuditRecordCategoryType.Spaces)) {
                        String currentSpaceKey;
                        if (isSearchByUser && userNames.contains(authorName)) {
                            details = this.getFormattedSpaceByKey(this.getChangeValue(auditEntity.getChangedValues(), "Space key", true), outputFormat, spaceNameObjectMap);
                            eventResultList.add(new EventModel(Date.from(auditEntity.getTimestamp()), auditRecordCategoryAsString, this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), auditEntity.getAuditType().getCategory(), details));
                            return;
                        }
                        if (isSearchBySpace && (currentSpaceKey = this.getChangeValue(auditEntity.getChangedValues(), "Space key", true)).equals(spaceKeyToSearch)) {
                            eventResultList.add(new EventModel(Date.from(auditEntity.getTimestamp()), auditRecordCategoryAsString, this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), this.getFormattedUserNames(authorName, outputFormat, userNameObjectMap), auditEntity.getAuditType().getCategory(), this.getFormattedSpaceByKey(currentSpaceKey, outputFormat, spaceNameObjectMap)));
                            return;
                        }
                    }
                });
                auditEntityCursorPage = auditEntityCursorPage.getNextPageRequest().isPresent() ? this.auditSearchService.findBy(auditQuery, (com.atlassian.audit.api.util.pagination.PageRequest)auditEntityCursorPage.getNextPageRequest().get()) : null;
            }
        }
        catch (Exception e) {
            return ImmutableMap.of((Object)"results", (Object)eventResultList, (Object)"statusCode", (Object)1, (Object)"message", (Object)"Timeout exception");
        }
        return ImmutableMap.of((Object)"results", (Object)eventResultList, (Object)"statusCode", (Object)0);
    }

    private AuditQuery buildQuery(String eventTypeToSearch, Instant instantFrom, Instant instantTo) {
        AuditQuery.Builder builder = AuditQuery.builder();
        if (!eventTypeToSearch.equalsIgnoreCase("All")) {
            builder.categories(new String[]{eventTypeToSearch});
        } else {
            builder.categories(new String[]{"Users and groups", "Permissions", "Spaces"});
        }
        builder.from(instantFrom);
        builder.to(instantTo);
        return builder.build();
    }

    private boolean isContainAffectedObject(Set<String> list, String affectedObjects) {
        if (affectedObjects.contains(",")) {
            ArrayList affectedObjectsList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)affectedObjects));
            boolean result = false;
            for (String affectedObject : affectedObjectsList) {
                result = list.stream().anyMatch(listElement -> listElement.equals(affectedObject));
                if (!result) continue;
                break;
            }
            return result;
        }
        return list.contains(affectedObjects);
    }

    public List<EventModel> filterCurrentEvents(String userNameToSearch, String groupNameToSearch, String spaceKeyToSearch, String format) {
        Space space;
        ArrayList spaceKeys;
        ArrayList eventResultList = Lists.newArrayList();
        HashSet userNames = Sets.newHashSet();
        HashSet groupNames = Sets.newHashSet();
        HashMap userNameObjectMap = Maps.newHashMap();
        HashMap spaceNameObjectMap = Maps.newHashMap();
        HashMap groupNameObjectMap = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)spaceKeyToSearch)) {
            spaceKeys = spaceKeyToSearch.contains(",") ? Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)spaceKeyToSearch)) : Lists.newArrayList((Object[])new String[]{spaceKeyToSearch});
            for (String spaceKey : spaceKeys) {
                space = this.spaceManager.getSpace(spaceKey);
                Collection users = this.spacePermissionManager.getUsersWithPermissions(space);
                users.forEach(user -> userNames.add(user.getName()));
                Collection groups = this.spacePermissionManager.getGroupsWithPermissions(space);
                groups.forEach(group -> groupNames.add(group.getName()));
            }
        } else {
            spaceKeys = Lists.newArrayList((Iterable)this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT));
            if (!Strings.isNullOrEmpty((String)userNameToSearch)) {
                userNames.add(userNameToSearch);
                if (userNames.size() > 0) {
                    groupNames.addAll(this.getGroupNamesForUsers(userNames));
                }
            }
            if (!Strings.isNullOrEmpty((String)groupNameToSearch)) {
                ArrayList groups = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)groupNameToSearch));
                groupNames.addAll(groups);
            }
        }
        for (String spaceKey : spaceKeys) {
            space = this.spaceManager.getSpace(spaceKey);
            for (String groupName : groupNames) {
                String userNamesFromGroup = String.join((CharSequence)",", this.getUserNamesFromGroup(groupName));
                Arrays.stream(Permission.values()).filter(permission -> this.spacePermissionManager.groupHasPermission(permission.getName(), space, groupName)).forEach(permission -> eventResultList.add(EventModel.builder().author(this.getFormattedUserNames(userNamesFromGroup, format, userNameObjectMap)).userName(this.getFormattedGroupNames(groupName, format, groupNameObjectMap)).summary(this.i18n.getText(permission.getKey())).details(this.getFormattedSpaceByKey(spaceKey, format, spaceNameObjectMap)).build()));
            }
            for (String userName : userNames) {
                ConfluenceUser user2 = this.userManager.getUserByName(userName);
                Arrays.stream(Permission.values()).filter(arg_0 -> this.lambda$filterCurrentEvents$18(space, (User)user2, arg_0)).forEach(permission -> EventModel.builder().author(this.getFormattedUserNames(userName, format, userNameObjectMap)).userName(this.i18n.getText("java-permission-monitoring.author.name")).summary(this.i18n.getText(permission.getKey())).details(this.getFormattedSpaceByKey(spaceKey, format, spaceNameObjectMap)).build());
            }
        }
        return eventResultList;
    }

    private /* synthetic */ boolean lambda$filterCurrentEvents$18(Space space, User user, Permission permission) {
        return this.spacePermissionManager.hasPermission(permission.getName(), space, user);
    }

    static enum AuditRecordCategoryType {
        All,
        Other,
        Permissions,
        UsersAndGroups,
        Spaces;

    }

    static enum Permission {
        VIEWSPACE_PERMISSION("VIEWSPACE", "java-permission-monitoring.author.have-permission"),
        CREATEEDIT_PAGE_PERMISSION("EDITSPACE", "java-permission-monitoring.author.create-edit-permission"),
        EDITBLOG_PERMISSION("EDITBLOG", "java-permission-monitoring.author.edit-blog-permission"),
        CREATE_ATTACHMENT_PERMISSION("CREATEATTACHMENT", "java-permission-monitoring.author.create-edit-attachment"),
        EXPORT_SPACE_PERMISSION("EXPORTSPACE", "java-permission-monitoring.author.has-export-permission"),
        ADMINISTER_SPACE_PERMISSION("SETSPACEPERMISSIONS", "java-permission-monitoring.author.has-admin-permission");

        private final String name;
        private final String key;

        private Permission(String name, String key) {
            this.name = name;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }
    }
}

