/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.gdpr.general.manager.GDPRAbstractEntityDao;
import de.actonic.gdpr.newDC.ao.TemplateDCEntity;
import de.actonic.gdpr.shared.general.manager.IGDPRStreamExportManager;
import de.actonic.gdpr.shared.general.model.GDPRVersionType;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.newDC.model.template.ActionDCModel;
import de.actonic.gdpr.shared.newDC.model.template.ConditionDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TemplateDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TemplateScopeDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TriggerDCModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateDCDao
extends GDPRAbstractEntityDao {
    @Autowired
    public TemplateDCDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public TemplateDCEntity getTemplateById(Integer templateId) {
        return (TemplateDCEntity)this.ao.get(TemplateDCEntity.class, (Object)templateId);
    }

    public TemplateDCEntity createSimpleTemplate(String templateType, String creator, Set<String> contributors, Integer version, Boolean enabled) {
        TemplateDCEntity entity = (TemplateDCEntity)this.ao.create(TemplateDCEntity.class, new DBParam[0]);
        entity.setTemplateType(templateType);
        entity.setCreator(creator);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.setVersion(version);
        entity.setCreationDate(new Date());
        entity.setEnabled(enabled);
        entity.setLastModifier(creator);
        entity.setModificationDate(new Date());
        entity.setActions(GDPRJsonUtils.toJson((Object)Lists.newArrayList()));
        entity.setConditions(GDPRJsonUtils.toJson((Object)Lists.newArrayList()));
        entity.save();
        return entity;
    }

    public TemplateDCEntity updateConditions(Integer id, String lastModifier, Set<String> contributors, List<ConditionDCModel> conditions) {
        TemplateDCEntity entity = this.getTemplateById(id);
        entity.setLastModifier(lastModifier);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.setModificationDate(new Date());
        entity.setConditions(GDPRJsonUtils.toJson(conditions));
        entity.save();
        return entity;
    }

    public TemplateDCEntity updateActions(Integer id, String lastModifier, Set<String> contributors, List<ActionDCModel> actions) {
        TemplateDCEntity entity = this.getTemplateById(id);
        entity.setLastModifier(lastModifier);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.setModificationDate(new Date());
        entity.setActions(GDPRJsonUtils.toJson(actions));
        entity.save();
        return entity;
    }

    public List<TemplateDCEntity> getTemplateByTypes(ArrayList<String> types) {
        Query query = Query.select().order("ID ASC");
        query.setWhereClause(TemplateDCDao.createWhereClause(types, ",", "TEMPLATE_TYPE IN (", ") "));
        query.setWhereParams(types.toArray());
        return Lists.newArrayList((Object[])this.ao.find(TemplateDCEntity.class, query));
    }

    public List<TemplateDCEntity> getFilteredTemplates(Boolean isEnabled, ArrayList<String> triggerTypes) {
        Query query = Query.select().order("ID ASC");
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        if (isEnabled != null) {
            TemplateDCDao.appendDelimiter(sb, "ENABLED = ?");
            values.add(isEnabled);
        }
        if (!triggerTypes.isEmpty()) {
            TemplateDCDao.appendDelimiter(sb, TemplateDCDao.createWhereClause(triggerTypes, ",", "TRIGGER_TYPE IN (", ") "));
            values.addAll(triggerTypes);
        }
        if (sb.length() > 0 && !values.isEmpty()) {
            query.setWhereClause(sb.toString());
            query.setWhereParams(values.toArray());
        }
        return Lists.newArrayList((Object[])this.ao.find(TemplateDCEntity.class, query));
    }

    public TemplateDCEntity updateContributors(Integer id, Set<String> contributors) {
        TemplateDCEntity entity = this.getTemplateById(id);
        entity.setContributors(GDPRJsonUtils.toJson(contributors));
        entity.save();
        return entity;
    }

    public TemplateDCEntity updateTemplate(Integer id, String templateType, String lastModifier) {
        TemplateDCEntity entity = this.getTemplateById(id);
        entity.setTemplateType(templateType);
        entity.setLastModifier(lastModifier);
        entity.setModificationDate(new Date());
        entity.save();
        return entity;
    }

    public TemplateDCEntity createTemplateDraft(String name, Boolean skipScanned, Boolean enabled, List<String> fields, String creator, String triggerType, TemplateScopeDCModel scopeType, TriggerDCModel trigger, List<ActionDCModel> actions, List<ConditionDCModel> conditions, Integer version, String templateType, Integer parentId, Set<String> contributors) {
        TemplateDCEntity entity = (TemplateDCEntity)this.ao.create(TemplateDCEntity.class, new DBParam[0]);
        TemplateDCDao.setIfNotNull(name, entity::setName);
        TemplateDCDao.setIfNotNull(skipScanned, entity::setSkipScanned);
        TemplateDCDao.setIfNotNull(enabled, entity::setEnabled);
        GDPRJsonUtils.setJsonIfNotNull(fields, entity::setFields);
        TemplateDCDao.setIfNotNull(creator, entity::setCreator);
        entity.setCreationDate(new Date());
        TemplateDCDao.setIfNotNull(creator, entity::setLastModifier);
        entity.setModificationDate(new Date());
        TemplateDCDao.setIfNotNull(triggerType, entity::setTriggerType);
        GDPRJsonUtils.setJsonIfNotNull((Object)scopeType, entity::setScopeType);
        GDPRJsonUtils.setJsonIfNotNull((Object)trigger, entity::setTrigger);
        GDPRJsonUtils.setJsonIfNotNull(actions, entity::setActions);
        GDPRJsonUtils.setJsonIfNotNull(conditions, entity::setConditions);
        TemplateDCDao.setIfNotNull(version, entity::setVersion);
        TemplateDCDao.setIfNotNull(templateType, entity::setTemplateType);
        TemplateDCDao.setIfNotNull(parentId, entity::setParentId);
        GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
        entity.save();
        return entity;
    }

    public void deleteTemplate(Integer templateId) {
        TemplateDCEntity entity = this.getTemplateById(templateId);
        this.ao.delete(new RawEntity[]{entity});
    }

    public TemplateDCEntity[] getDraftTemplate(Integer parentId) {
        return (TemplateDCEntity[])this.ao.find(TemplateDCEntity.class, Query.select().where("PARENT_ID = ? AND TEMPLATE_TYPE = ?", new Object[]{parentId, GDPRVersionType.DRAFT.getType()}).order("ID ASC"));
    }

    public TemplateDCEntity updateTemplate(boolean isFullUpdate, Integer id, String name, Boolean skipScanned, Boolean enabled, List<String> fields, String creator, String lastModifier, Date creationDate, String triggerType, TriggerDCModel trigger, TemplateScopeDCModel scopeType, List<ConditionDCModel> conditions, List<ActionDCModel> actions, Integer version, String templateType, Integer parentId, Set<String> contributors, String comment) {
        TemplateDCEntity entity = this.getFirstByField(TemplateDCEntity.class, "ID", id);
        TemplateDCDao.setIfNotNull(name, entity::setName);
        TemplateDCDao.setIfNotNull(skipScanned, entity::setSkipScanned);
        TemplateDCDao.setIfNotNull(enabled, entity::setEnabled);
        GDPRJsonUtils.setJsonIfNotNull(fields, entity::setFields);
        TemplateDCDao.setIfNotNull(triggerType, entity::setTriggerType);
        GDPRJsonUtils.setJsonIfNotNull((Object)trigger, entity::setTrigger);
        GDPRJsonUtils.setJsonIfNotNull((Object)scopeType, entity::setScopeType);
        if (isFullUpdate) {
            GDPRJsonUtils.setJsonIfNotNull(conditions, entity::setConditions);
            GDPRJsonUtils.setJsonIfNotNull(actions, entity::setActions);
            entity.setCreator(creator);
            entity.setCreationDate(creationDate);
            entity.setModificationDate(new Date());
            entity.setLastModifier(lastModifier);
            entity.setVersion(version);
            entity.setTemplateType(templateType);
            entity.setParentId(parentId);
            GDPRJsonUtils.setJsonIfNotNull(contributors, entity::setContributors);
            entity.setComment(comment);
        }
        entity.save();
        return entity;
    }

    public void getAllInStream(IGDPRStreamExportManager streamExportManager, TemplateDCModel template) {
        this.ao.stream(TemplateDCEntity.class, templateDCEntity -> {
            template.setLastModifier(templateDCEntity.getLastModifier());
            template.setName(templateDCEntity.getName());
            streamExportManager.flush((Object)template);
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

