/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.upgrade.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import de.actonic.confluence.gdpr.ao.AccessStatisticsEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.ao.AnnouncingHistoryEntity;
import de.actonic.confluence.gdpr.ao.DataRuleEntity;
import de.actonic.confluence.gdpr.component.manager.UserNameConvertManager;
import de.actonic.gdpr.general.manager.GDPRSettingsManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask001
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask001.class);
    private final GDPRSettingsManager GDPRSettingsManager;
    private final UserNameConvertManager userNameConvertManager;

    public UpgradeTask001(GDPRSettingsManager GDPRSettingsManager2, UserNameConvertManager userNameConvertManager) {
        this.GDPRSettingsManager = GDPRSettingsManager2;
        this.userNameConvertManager = userNameConvertManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        String lastModifierUserKey;
        String creatorUserKey;
        String lastModifierUserName;
        String creatorUserName;
        String userKey;
        String userName;
        int count;
        activeObjects.migrate(new Class[]{AccessStatisticsEntity.class, AnnouncingEntity.class, AnnouncingHistoryEntity.class, DataRuleEntity.class});
        log.info("Start updating configuration...");
        String runTaskUserName = this.GDPRSettingsManager.getRunTasksFromUser();
        if (StringUtils.isNotBlank((CharSequence)runTaskUserName)) {
            String runTaskUserKey = this.userNameConvertManager.convertUserNameToUserKey(runTaskUserName);
            this.GDPRSettingsManager.setRunTasksFromUser(runTaskUserKey);
        }
        log.info("Configuration updated.");
        log.info("Start updating 'AccessStatistics' entities");
        try {
            count = 0;
            AccessStatisticsEntity[] accessStatisticsEntities = (AccessStatisticsEntity[])activeObjects.find(AccessStatisticsEntity.class);
            for (AccessStatisticsEntity accessStatisticsEntity : accessStatisticsEntities) {
                userName = accessStatisticsEntity.getUserName();
                userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
                accessStatisticsEntity.setUserName(userKey);
                accessStatisticsEntity.save();
                log.info(String.format("[%d: %d]: %s", ++count, accessStatisticsEntities.length, "success"));
            }
            log.info("AccessStatistics entities updated.");
        }
        catch (Exception e) {
            log.info("AccessStatistics entities failed. Error: " + e.getLocalizedMessage());
        }
        log.info("Start updating 'Announcing' entities");
        try {
            count = 0;
            AnnouncingEntity[] announcingEntities = (AnnouncingEntity[])activeObjects.find(AnnouncingEntity.class);
            for (AnnouncingEntity announcingEntity : announcingEntities) {
                creatorUserName = announcingEntity.getCreator();
                lastModifierUserName = announcingEntity.getLastModifier();
                creatorUserKey = this.userNameConvertManager.convertUserNameToUserKey(creatorUserName);
                lastModifierUserKey = this.userNameConvertManager.convertUserNameToUserKey(lastModifierUserName);
                announcingEntity.setCreator(creatorUserKey);
                announcingEntity.setLastModifier(lastModifierUserKey);
                announcingEntity.save();
                log.info(String.format("[%d: %d]: %s", ++count, announcingEntities.length, "success"));
            }
            log.info("Announcing entities updated.");
        }
        catch (Exception e) {
            log.info("Announcing entities failed. Error: " + e.getLocalizedMessage());
        }
        log.info("Start updating 'AnnouncingHistory' entities");
        try {
            count = 0;
            AnnouncingHistoryEntity[] announcingHistoryEntities = (AnnouncingHistoryEntity[])activeObjects.find(AnnouncingHistoryEntity.class);
            for (AnnouncingHistoryEntity announcingHistoryEntity : announcingHistoryEntities) {
                userName = announcingHistoryEntity.getUser();
                userKey = this.userNameConvertManager.convertUserNameToUserKey(userName);
                announcingHistoryEntity.setUser(userKey);
                announcingHistoryEntity.save();
                log.info(String.format("[%d: %d]: %s", ++count, announcingHistoryEntities.length, "success"));
            }
            log.info("AnnouncingHistory entities updated.");
        }
        catch (Exception e) {
            log.info("AnnouncingHistory entities failed. Error: " + e.getLocalizedMessage());
        }
        log.info("Start updating 'DataRule' entities");
        try {
            count = 0;
            DataRuleEntity[] dataRuleEntities = (DataRuleEntity[])activeObjects.find(DataRuleEntity.class);
            for (DataRuleEntity dataRuleEntity : dataRuleEntities) {
                creatorUserName = dataRuleEntity.getCreator();
                lastModifierUserName = dataRuleEntity.getLastModifier();
                creatorUserKey = this.userNameConvertManager.convertUserNameToUserKey(creatorUserName);
                lastModifierUserKey = this.userNameConvertManager.convertUserNameToUserKey(lastModifierUserName);
                dataRuleEntity.setCreator(creatorUserKey);
                dataRuleEntity.setLastModifier(lastModifierUserKey);
                dataRuleEntity.save();
                log.info(String.format("[%d: %d]: %s", ++count, dataRuleEntities.length, "success"));
            }
            log.info("DataRule entities updated.");
        }
        catch (Exception e) {
            log.info("DataRule entities failed. Error: " + e.getLocalizedMessage());
        }
    }
}

