/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.service.RequestMyDataService;
import de.actonic.confluence.gdpr.model.RequestDataHistoryModel;
import de.actonic.confluence.gdpr.model.RequestDataModel;
import de.actonic.confluence.gdpr.model.RequestDataShowedModel;
import de.actonic.confluence.gdpr.model.RequestRelationTypeEnum;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="request-my-data")
public class RequestMyDataRest {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final I18nResolver i18n;
    private final RequestMyDataService requestMyDataService;

    @Autowired
    public RequestMyDataRest(@Qualifier(value="userManager") UserManager userManager, I18nResolver i18n, RequestMyDataService requestMyDataService) {
        this.userManager = userManager;
        this.i18n = i18n;
        this.requestMyDataService = requestMyDataService;
    }

    @POST
    @Path(value="request")
    public Response createRequest(@FormParam(value="user") String user) {
        boolean created = false;
        try {
            this.requestMyDataService.createRequest(user);
            created = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.ok((Object)String.valueOf(created)).build();
    }

    @GET
    @Path(value="request")
    public Response getRequestStatus(@QueryParam(value="user") String userKey) {
        try {
            RequestDataShowedModel dataModel = StringUtils.isNotBlank((CharSequence)userKey) ? this.requestMyDataService.convertToShowedModel(this.requestMyDataService.getUserRequest(userKey)) : this.requestMyDataService.convertToShowedModel(this.requestMyDataService.getCurrentRequest());
            if (dataModel != null) {
                return Response.ok((Object)new Gson().toJson((Object)dataModel), (String)"application/json").build();
            }
            return Response.noContent().build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="request")
    public Response cancelRequest(@FormParam(value="id") Integer requestId) {
        try {
            this.requestMyDataService.cancelRequest(requestId);
            return Response.ok().build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="history")
    public Response getHistory() {
        try {
            List<RequestDataModel> tmp = this.requestMyDataService.getHistoryRequests();
            List result = tmp.stream().map(el -> this.requestMyDataService.convertToShowedModel((RequestDataModel)el)).collect(Collectors.toList());
            return Response.ok((Object)new Gson().toJson(result), (String)"application/json").build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="queue")
    public Response getQueue() {
        try {
            List<RequestDataModel> tmp = this.requestMyDataService.getQueueRequests();
            List result = tmp.stream().map(el -> this.requestMyDataService.convertToShowedModel((RequestDataModel)el)).collect(Collectors.toList());
            return Response.ok((Object)new Gson().toJson(result), (String)"application/json").build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="proceed")
    public Response proceedRequest() {
        try {
            return Response.ok((Object)this.requestMyDataService.execute().getMessage()).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="results")
    public Response getRequestResults(@QueryParam(value="user") String userName, @QueryParam(value="rowsPerPage") Integer rowsPerPage, @QueryParam(value="relationType") Integer relationType, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") Integer page) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)userName) || this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            List<RequestDataHistoryModel> results = this.requestMyDataService.getRequestResults(userName, rowsPerPage, relationType, orderBy, page);
            if (results != null) {
                data.put("items", results);
                data.put("page", page);
                data.put("totalPages", this.requestMyDataService.getNumberOfPages(userName, rowsPerPage, relationType));
            } else {
                data.put("error", "There is no results for this request");
            }
        } else {
            data.put("error", "You don't have permissions to view this request");
        }
        return Response.ok((Object)new Gson().toJson(data), (String)"application/json").build();
    }

    @GET
    @Path(value="results/general")
    public Response getGeneralRequestResults(@QueryParam(value="user") String userName) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)userName) || this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            LinkedList<Integer> relations = new LinkedList<Integer>();
            for (RequestRelationTypeEnum type : RequestRelationTypeEnum.values()) {
                relations.add(type.getCode(), this.requestMyDataService.getRelationResult(userName, type.getCode()));
            }
            RequestDataModel model = this.requestMyDataService.getLastFinishedUserRequest(userName);
            if (model != null) {
                Long createdLong = model.getCreateDate();
                data.put("created", new Date(createdLong).toString());
                data.put("relations", relations);
                data.put("total", this.requestMyDataService.getRelationResult(userName, null));
            } else {
                data.put("error", "There is no results for this request");
            }
        } else {
            data.put("error", "You don't have permissions to view this request");
        }
        return Response.ok((Object)new Gson().toJson(data), (String)"application/json").build();
    }

    @GET
    @Path(value="export")
    public Response getExportFile(@QueryParam(value="user") String userName, @QueryParam(value="relationType") Integer relationType, @QueryParam(value="orderBy") String orderBy) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)userName) || this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            List<RequestDataHistoryModel> results = this.requestMyDataService.getRequestResults(userName, -1, relationType, orderBy, -1);
            String fileName = RequestMyDataRest.generateExportFileName();
            try {
                File file = File.createTempFile(fileName, "csv");
                CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Relation Type", "Entity", "Parent entity", "Space"});
                FileWriter fileWriter = new FileWriter(file);
                CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
                results.forEach(rec -> {
                    try {
                        String parentString = StringUtils.isNotBlank((CharSequence)rec.getParentObject()) ? rec.getParentTitle() + " (entityId:" + rec.getParentObject() + ")" : "";
                        String spaceString = rec.getExtra() != null && rec.getExtra().containsKey("spaceName") ? rec.getExtra().get("spaceName") + " (" + rec.getSpaceKey() + ")" : rec.getSpaceKey();
                        csvFilePrinter.printRecord(new Object[]{this.getRelationName(rec.getRelationType()), rec.getCurrentTitle() + " (entityId:" + rec.getCurrentObject() + ")", parentString, spaceString});
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                fileWriter.flush();
                fileWriter.close();
                csvFilePrinter.close();
                Response.ResponseBuilder response = Response.ok((Object)file);
                response.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + ".csv\""));
                return response.build();
            }
            catch (IOException e) {
                e.printStackTrace();
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Gson().toJson((Object)e.getMessage())).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to view this request").build();
    }

    private static String generateExportFileName() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy-HH.mm.ss");
        Date today = Calendar.getInstance().getTime();
        String reportDate = df.format(today);
        return "request-my-data-export-" + reportDate;
    }

    private String getRelationName(Integer relation) {
        return this.i18n.getText("soy-request-my-data.relations.item-" + relation);
    }
}

