/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerScheduleModel;
import de.actonic.confluence.gdpr.component.manager.CronManager;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerScheduleEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerSchedulerDao;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerSchedulerManager {
    private final DataCleanerSchedulerDao dataCleanerSchedulerDao;
    private final CronManager cronExpressionsManager;

    @Autowired
    public DataCleanerSchedulerManager(DataCleanerSchedulerDao dataCleanerSchedulerDao, CronManager cronExpressionsManager) {
        this.dataCleanerSchedulerDao = dataCleanerSchedulerDao;
        this.cronExpressionsManager = cronExpressionsManager;
    }

    public DataCleanerScheduleModel entityToModel(DataCleanerScheduleEntity entity) {
        if (entity == null) {
            return null;
        }
        return DataCleanerScheduleModel.builder().id(entity.getID()).templateId(entity.getTemplateId()).cron(entity.getCron()).enabled(entity.isEnabled()).taskType(entity.getTaskType()).humanReadable(StringUtils.isNotBlank((String)entity.getCron()) ? this.cronExpressionsManager.getHumanReadableFormat(entity.getCron()) : "").build();
    }

    public List<DataCleanerScheduleModel> entitiesToModels(List<DataCleanerScheduleEntity> entities) {
        if (entities == null) {
            return Lists.newArrayList();
        }
        return entities.stream().map(e -> this.entityToModel((DataCleanerScheduleEntity)e)).collect(Collectors.toList());
    }

    public DataCleanerScheduleModel createCron(DataCleanerScheduleModel model) {
        DataCleanerScheduleEntity entity = this.dataCleanerSchedulerDao.create(model.getTemplateId(), model.getCron(), model.getEnabled(), model.getTaskType());
        return this.entityToModel(entity);
    }

    public DataCleanerScheduleModel updateCron(Integer cronId, DataCleanerScheduleModel model) {
        return this.entityToModel(this.dataCleanerSchedulerDao.update(cronId, model.getTemplateId(), model.getCron(), model.getEnabled(), model.getTaskType()));
    }

    public void deleteCron(Integer cronId) {
        this.dataCleanerSchedulerDao.delete(cronId);
    }

    public List<DataCleanerScheduleModel> getCronsForTemplate(Integer templateId) {
        return this.entitiesToModels(this.dataCleanerSchedulerDao.getScheduledTasksForTemplate(templateId));
    }

    public DataCleanerScheduleModel getCron(Integer cronId) {
        return this.entityToModel(this.dataCleanerSchedulerDao.getById(cronId));
    }

    public List<DataCleanerScheduleModel> getActiveScheduledTasks() {
        return this.entitiesToModels(this.dataCleanerSchedulerDao.getAllActiveScheduledTasks());
    }

    public boolean isCronValid(String cron) {
        return this.cronExpressionsManager.isCronValid(cron) && this.cronExpressionsManager.isCronDurationValid(cron);
    }

    public String getHumanReadableFormat(String cron) {
        if (this.isCronValid(cron)) {
            return this.cronExpressionsManager.getHumanReadableFormat(cron);
        }
        return "";
    }
}

