/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleaner3dPartyAddonsStatusType;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleaner3dPartyAddonEntity;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleaner3dPartyAddonsDao
extends AbstractEntityDao {
    @Autowired
    public DataCleaner3dPartyAddonsDao(ActiveObjects ao) {
        super(ao);
    }

    public DataCleaner3dPartyAddonEntity get(Integer id) {
        DataCleaner3dPartyAddonEntity entity = (DataCleaner3dPartyAddonEntity)this.ao.get(DataCleaner3dPartyAddonEntity.class, (Object)id);
        return entity;
    }

    public DataCleaner3dPartyAddonEntity create(Integer taskId, String eventId, String eventyType, String status, String anonymizerName, String statusMessage) {
        return (DataCleaner3dPartyAddonEntity)this.ao.executeInTransaction(() -> {
            DataCleaner3dPartyAddonEntity entity = (DataCleaner3dPartyAddonEntity)this.ao.create(DataCleaner3dPartyAddonEntity.class, new DBParam[0]);
            entity.setTaskId(taskId);
            entity.setEventId(eventId);
            entity.setEventType(eventyType);
            entity.setStatus(status);
            entity.setAnonymizerName(anonymizerName);
            entity.setStatusMessage(statusMessage);
            entity.setLastUpdated(new Date());
            entity.save();
            return entity;
        });
    }

    public DataCleaner3dPartyAddonEntity update(Integer id, String status, String statusMessage) {
        return (DataCleaner3dPartyAddonEntity)this.ao.executeInTransaction(() -> {
            DataCleaner3dPartyAddonEntity entity = this.get(id);
            if (entity != null) {
                entity.setStatus(status);
                entity.setStatusMessage(statusMessage);
                entity.setLastUpdated(new Date());
                entity.save();
            }
            return entity;
        });
    }

    public DataCleaner3dPartyAddonEntity[] getByTaskId(Integer taskId) {
        return (DataCleaner3dPartyAddonEntity[])this.ao.executeInTransaction(() -> {
            DataCleaner3dPartyAddonEntity[] entities = (DataCleaner3dPartyAddonEntity[])this.ao.find(DataCleaner3dPartyAddonEntity.class, Query.select().where("TASK_ID = ?", new Object[]{taskId}).order("ID ASC"));
            return entities;
        });
    }

    public DataCleaner3dPartyAddonEntity getByEventId(String eventId) {
        DataCleaner3dPartyAddonEntity entity = this.getFirstByField(DataCleaner3dPartyAddonEntity.class, "EVENT_ID", eventId);
        return entity;
    }

    public DataCleaner3dPartyAddonEntity[] getStillActiveAddonsAfter1H(Date paramDate) {
        return (DataCleaner3dPartyAddonEntity[])this.ao.executeInTransaction(() -> (DataCleaner3dPartyAddonEntity[])this.ao.find(DataCleaner3dPartyAddonEntity.class, Query.select().where("(STATUS = ? OR STATUS = ?) AND LAST_UPDATED < ?", new Object[]{DataCleaner3dPartyAddonsStatusType.STARTED.getType(), DataCleaner3dPartyAddonsStatusType.PROCESSING.getType(), paramDate}).order("ID ASC")));
    }

    public void delete(Integer id) {
        this.ao.executeInTransaction(() -> {
            DataCleaner3dPartyAddonEntity entity = this.get(id);
            if (entity != null) {
                this.ao.delete(new RawEntity[]{entity});
            }
            return true;
        });
    }

    public void deleteByEventId(String eventId) {
        this.ao.executeInTransaction(() -> {
            this.ao.deleteWithSQL(DataCleaner3dPartyAddonEntity.class, "EVENT_ID = ?", new Object[]{eventId});
            return true;
        });
    }

    public void deleteByTaskId(Integer taskId) {
        this.ao.executeInTransaction(() -> {
            this.ao.deleteWithSQL(DataCleaner3dPartyAddonEntity.class, "TASK_ID = ?", new Object[]{taskId});
            return true;
        });
    }
}

