/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.global;

import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.GlobalContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlobalPermissionChanger
extends GlobalContentChanger {
    private static final Logger log = LoggerFactory.getLogger(GlobalPermissionChanger.class);
    public static final String NAME = "deleteFromGlobalPermissions";
    @ComponentImport
    private final SpacePermissionManager spacePermissionManager;

    @Autowired
    protected GlobalPermissionChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, SpacePermissionManager spacePermissionManager) {
        super(pluginSettingsFactory);
        this.spacePermissionManager = spacePermissionManager;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, ConfluenceUser sourceUser) {
        this.setJobMessage(currentJobId, "Remove user from global permissions...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        List globalPermissions = this.spacePermissionManager.getGlobalPermissions();
        List sourceUserPermissions = globalPermissions.stream().filter(x -> x.getType().equals("USECONFLUENCE")).filter(perm -> Objects.equals(perm.getUserSubject(), sourceUser)).collect(Collectors.toList());
        try {
            for (SpacePermission sourceUserPermission : sourceUserPermissions) {
                this.spacePermissionManager.removePermission(sourceUserPermission);
            }
        }
        catch (Exception e) {
            changesFail = e.getMessage();
            e.printStackTrace();
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }
}

