/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentAuthorChanger
extends BasicContentChanger {
    private static final String NAME = "changeCommentAuthor";
    private CommentManager commentManager;
    private PageManager pageManager;
    private TransactionTemplate transactionTemplate;

    @Autowired
    public CommentAuthorChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PageManager pageManager, @ComponentImport CommentManager commentManager, @ComponentImport TransactionTemplate transactionTemplate) {
        super(pluginSettingsFactory, transactionTemplate);
        this.pageManager = pageManager;
        this.commentManager = commentManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            ContentEntityObject issue = this.pageManager.getById(pissue.getId());
            List comments = issue.getComments();
            for (Comment comment : comments) {
                try {
                    return this.isAffectedComment(comment, user);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        });
    }

    private boolean isAffectedComment(Comment comment, ConfluenceUser user) {
        return comment != null && comment.getCreator() != null && comment.getLastModifier() != null && (comment.getCreator().equals(user) || comment.getLastModifier().equals(user));
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating comments author...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        List comments = ((ContentEntityObject)issue).getComments();
        int commentSize = comments.size();
        for (Comment comment : comments) {
            if (!this.isAffectedComment(comment, sourceUser)) continue;
            changesTotal = changesTotal + comment.getId() + ", ";
            boolean transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                this.setJobMessage(currentJobId, "Updating author for comment " + comment.getId() + "(" + comments.indexOf(comment) + " of " + commentSize + ")");
                try {
                    Comment entity = this.commentManager.getComment(comment.getId());
                    if (entity.getCreator().equals(sourceUser)) {
                        entity.setCreator(targetUser);
                    }
                    if (entity.getLastModifier().equals(sourceUser)) {
                        entity.setLastModifier(targetUser);
                    }
                    this.commentManager.saveContentEntity((ContentEntityObject)entity, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(false).suppressAutowatch(true).suppressNotifications(true)).build());
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            });
            if (transactionResult) {
                changesSuccess = changesSuccess + comment.getId() + ", ";
                continue;
            }
            changesFail = changesFail + comment.getId() + ", ";
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }
}

