/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PagePermissionChanger
extends BasicContentChanger {
    private static final Logger log = LoggerFactory.getLogger(PagePermissionChanger.class);
    public static final String NAME = "changeUserPermissions";
    @ComponentImport
    private PermissionManager permissionManager;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @ComponentImport
    private ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private ChangeIndexer changeIndexer;

    @Autowired
    protected PagePermissionChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, PermissionManager permissionManager, PageManager pageManager, TransactionTemplate transactionTemplate, ContentPermissionManager contentPermissionManager, ChangeIndexer changeIndexer) {
        super(pluginSettingsFactory, transactionTemplate);
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.contentPermissionManager = contentPermissionManager;
        this.changeIndexer = changeIndexer;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            try {
                String[] permissionType;
                log.debug(">> pagePermissionChanger (isAffected) > trying to get page with id = " + pissue.getId());
                ContentEntityObject issue = this.pageManager.getById(pissue.getId());
                log.debug(">> pagePermissionChanger (isAffected) > found page=" + (issue != null));
                for (String type : permissionType = new String[]{"View", "Edit"}) {
                    ContentPermissionSet contentPermissions = issue.getContentPermissionSet(type);
                    log.debug(">> pagePermissionChanger (change) > getting content permissions of type=" + type + ", found=" + (contentPermissions != null));
                    if (contentPermissions == null) continue;
                    return this.hasUserPermissions(contentPermissions.getUserKeys(), user);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                log.error(e.getStackTrace().toString());
                e.printStackTrace();
            }
            return false;
        });
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating user permissions...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        String[] permissionType = new String[]{"View", "Edit"};
        log.debug(">> pagePermissionChanger (change) > isAffected?");
        if (this.isAffected(issue, sourceUser)) {
            changesTotal = changesTotal + issue.getId() + ", ";
            log.debug(">> pagePermissionChanger (change) > foundAffectedPage with page=" + issue.getId());
            boolean transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                try {
                    ContentEntityObject entity = this.pageManager.getById(issue.getId());
                    for (String type : permissionType) {
                        ArrayList newPermissionList = Lists.newArrayList();
                        ContentPermissionSet contentPermissions = entity.getContentPermissionSet(type);
                        log.debug(">> pagePermissionChanger (change) > getting content permissions of type=" + type + ", found=" + (contentPermissions != null));
                        this.setJobMessage(currentJobId, "Updating user permissions for page " + entity.getId());
                        if (contentPermissions != null) {
                            Collection contentPermissionList = contentPermissions.getAllExcept((Collection)Lists.newArrayList());
                            log.debug(">> pagePermissionChanger (change) > getting contentPermissionList > notNull=" + (contentPermissionList != null) + ", sizeExists=" + (contentPermissionList != null && contentPermissionList.size() > 0));
                            for (ContentPermission permission : contentPermissionList) {
                                ContentPermission newPermission;
                                log.debug(">> pagePermissionChanger (change) > isPermissionEqualsSourceUser = " + (permission.getUserSubject() != null ? Boolean.valueOf(permission.getUserSubject().equals(sourceUser)) : "no-user"));
                                if (permission.getUserSubject() != null && permission.getUserSubject().equals(sourceUser)) {
                                    newPermission = ContentPermission.createUserPermission((String)type, (ConfluenceUser)targetUser);
                                    newPermission.setCreator(targetUser);
                                    newPermission.setLastModifier(targetUser);
                                } else {
                                    newPermission = permission;
                                }
                                newPermissionList.add(newPermission);
                            }
                        }
                        log.debug(">> pagePermissionChanger (change) > trying to save new permissionList");
                        this.contentPermissionManager.setContentPermissions((Collection)newPermissionList, entity, type);
                        log.debug(">> pagePermissionChanger (change) > saved");
                    }
                    return true;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getStackTrace().toString());
                    e.printStackTrace();
                    return false;
                }
            });
            if (transactionResult) {
                changesSuccess = changesSuccess + issue.getId() + ", ";
            } else {
                changesFail = changesFail + issue.getId() + ", ";
            }
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    private boolean hasUserPermissions(List<UserKey> userKeys, ConfluenceUser user) {
        for (UserKey userKey : userKeys) {
            if (!userKey.equals((Object)user.getKey())) continue;
            return true;
        }
        return false;
    }
}

