/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.ao.DataRuleEntity;
import de.actonic.confluence.gdpr.ao.DataRuleHistoryEntity;
import de.actonic.confluence.gdpr.component.manager.DataRuleDao;
import de.actonic.confluence.gdpr.component.manager.DataRuleHistoryDao;
import de.actonic.confluence.gdpr.model.DataRuleHistoryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleHistoryService {
    private final DataRuleDao dataRuleDao;
    private final DataRuleHistoryDao dataRuleHistoryDao;

    @Autowired
    public DataRuleHistoryService(DataRuleDao dataRuleDao, DataRuleHistoryDao dataRuleHistoryDao) {
        this.dataRuleDao = dataRuleDao;
        this.dataRuleHistoryDao = dataRuleHistoryDao;
    }

    public DataRuleHistoryModel createEntity(int ruleId, String details, String pageIds, int resultCode) {
        DataRuleHistoryEntity entity = this.dataRuleHistoryDao.createEntity(ruleId, details, pageIds, resultCode);
        return new DataRuleHistoryModel(entity);
    }

    public List<DataRuleHistoryModel> filterItemsByRule(int ruleId, long fromDate, long toDate) {
        List<DataRuleHistoryEntity> entities = this.dataRuleHistoryDao.getAllEntitiesByRule(ruleId);
        return this.filterByDates(entities, fromDate, toDate);
    }

    public List<DataRuleHistoryModel> filterItemsByPageId(String pageId, long fromDate, long toDate) {
        List<DataRuleHistoryEntity> entities = this.dataRuleHistoryDao.getAllEntities();
        ArrayList dataRuleHistoryModels = Lists.newArrayList();
        entities.forEach(entity -> {
            if (!entity.getPageIds().toLowerCase().contains(pageId.toLowerCase())) {
                return;
            }
            for (String key : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)pageId)) {
                if (!pageId.equalsIgnoreCase(key)) continue;
                dataRuleHistoryModels.add(this.entityToModel((DataRuleHistoryEntity)entity));
                break;
            }
        });
        return this.filterByDates(entities, fromDate, toDate);
    }

    private List<DataRuleHistoryModel> filterByDates(List<DataRuleHistoryEntity> entities, long fromDate, long toDate) {
        ArrayList dataRuleHistoryModels = Lists.newArrayList();
        entities.forEach(entity -> {
            if (fromDate != 0L && entity.getTimeStamp().getTime() < fromDate) {
                return;
            }
            if (toDate != 0L && entity.getTimeStamp().getTime() > toDate) {
                return;
            }
            dataRuleHistoryModels.add(this.entityToModel((DataRuleHistoryEntity)entity));
        });
        return dataRuleHistoryModels;
    }

    public List<DataRuleHistoryModel> getHistoryItems(long fromDate, long toDate) {
        List<DataRuleHistoryEntity> entities = this.dataRuleHistoryDao.getAllEntities();
        ArrayList dataRuleHistoryModels = Lists.newArrayList();
        entities.forEach(entity -> dataRuleHistoryModels.add(this.entityToModel((DataRuleHistoryEntity)entity)));
        return this.filterByDates(entities, fromDate, toDate);
    }

    public void sortEvents(List<DataRuleHistoryModel> historyModels, String sortBy) {
        if ("dateAsc".equals(sortBy)) {
            Collections.sort(historyModels, new Comparator<DataRuleHistoryModel>(){

                @Override
                public int compare(DataRuleHistoryModel event1, DataRuleHistoryModel event2) {
                    return event1.getTimeStamp().compareTo(event2.getTimeStamp());
                }
            });
        }
        if ("dateDesc".equals(sortBy)) {
            Collections.sort(historyModels, new Comparator<DataRuleHistoryModel>(){

                @Override
                public int compare(DataRuleHistoryModel event1, DataRuleHistoryModel event2) {
                    return event2.getTimeStamp().compareTo(event1.getTimeStamp());
                }
            });
        }
    }

    private DataRuleHistoryModel entityToModel(DataRuleHistoryEntity entity) {
        DataRuleEntity dataRuleEntity = this.dataRuleDao.getById(entity.getRuleId());
        String ruleName = dataRuleEntity == null ? entity.getRuleId() + " (deleted)" : dataRuleEntity.getName();
        return new DataRuleHistoryModel(entity.getID(), entity.getRuleId(), ruleName, entity.getDetails(), entity.getPageIds(), entity.getTimeStamp(), entity.getResultCode());
    }
}

