/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.ao.DataRuleEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataRuleHistoryManager
extends AbstractEntityDao {
    @Autowired
    public DataRuleHistoryManager(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public DataRuleEntity getById(int id) {
        DataRuleEntity entity = this.getFirstByField(DataRuleEntity.class, "ID", id);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    public DataRuleEntity createEntity(String name, String creator, String cron, String cql, String type, String parameters) {
        DataRuleEntity entity = (DataRuleEntity)this.ao.create(DataRuleEntity.class, new DBParam[0]);
        entity.setIsActive(true);
        entity.setName(name);
        entity.setCreator(creator);
        entity.setCreationDate(new Date());
        entity.setModificationDate(new Date());
        entity.setLastModifier(creator);
        entity.setCron(cron);
        entity.setCql(cql);
        entity.setParameters(parameters);
        entity.save();
        return entity;
    }

    public DataRuleEntity updateEntity(int id, String name, String modifier, String cron, String cql, String type, String parameters) {
        DataRuleEntity entity = this.getFirstByField(DataRuleEntity.class, "ID", id);
        entity.setName(name);
        entity.setModificationDate(new Date());
        entity.setLastModifier(modifier);
        entity.setCron(cron);
        entity.setCql(cql);
        entity.setParameters(parameters);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        DataRuleEntity entity = this.getFirstByField(DataRuleEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public List<DataRuleEntity> getAllEntities() {
        Object[] entities = (DataRuleEntity[])this.ao.find(DataRuleEntity.class);
        return Lists.newArrayList((Object[])entities);
    }

    public List<DataRuleEntity> getActiveEntities() {
        Object[] entities = (DataRuleEntity[])this.ao.find(DataRuleEntity.class, Query.select().where("IS_ACTIVE = ?", new Object[]{Boolean.TRUE}));
        return Lists.newArrayList((Object[])entities);
    }

    public DataRuleEntity disableRule(int id, ConfluenceUser applicationUser) {
        return this.setActiveField(id, applicationUser, Boolean.FALSE);
    }

    public DataRuleEntity enableRule(int id, ConfluenceUser applicationUser) {
        return this.setActiveField(id, applicationUser, Boolean.TRUE);
    }

    private DataRuleEntity setActiveField(int id, ConfluenceUser applicationUser, boolean isActive) {
        DataRuleEntity entity = this.getFirstByField(DataRuleEntity.class, "ID", id);
        entity.setIsActive(isActive);
        entity.setModificationDate(new Date());
        entity.setLastModifier(applicationUser.getKey().getStringValue());
        entity.save();
        return entity;
    }
}

