define("actonic-gdpr/permission-monitoring/rest", ["jquery"], function ($) {

    function Rest() {
        this.getAuditLogs = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/auditing/record",
                data: request,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.getHistoricalPermissions = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/permission-monitoring/historical",
                data: request,
                cache: false,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.getCurrentPermissions = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/permission-monitoring/current",
                data: request,
                cache: false,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }

        this.getExport = function (request, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: request,
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }
    }

    return new Rest();
});