/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceCreatorChanger
extends BasicContentChanger {
    private static final Logger log = LoggerFactory.getLogger(SpaceCreatorChanger.class);
    private static final String NAME = "changeSpaceCreator";
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private PageManager pageManager;

    @Autowired
    public SpaceCreatorChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, PageManager pageManager, TransactionTemplate transactionTemplate, SpaceManager spaceManager) {
        super(pluginSettingsFactory, transactionTemplate);
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            try {
                log.debug(">> spaceCreatorChanger (isAffected) > trying to get space with spaceKey=" + ((Space)pissue).getKey());
                Space space = this.spaceManager.getSpace(((Space)pissue).getKey());
                log.debug(">> spaceCreatorChanger (isAffected) > spaceFound=" + (space != null) + ", hasSpaceCreator=" + (space != null && space.getCreator() != null));
                if (space != null && space.getCreator() != null) {
                    log.debug(">> spaceCreatorChanger (isAffected) > affectedPermissions found");
                    return space.getCreator().equals(user);
                }
                log.debug(">> spaceCreatorChanger (isAffected) > affectedPermissions NOT found");
            }
            catch (Exception e) {
                log.error(e.getMessage());
                log.error(e.getStackTrace().toString());
                e.printStackTrace();
            }
            return false;
        });
    }

    @Override
    public String getAffectedContent(EntityObject issue, ConfluenceUser user) {
        if (this.isAffected(issue, user)) {
            return ((Space)issue).getKey() + ", ";
        }
        return "";
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating space creator...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        log.debug(">> spaceCreatorChanger (change) > executing for space=" + ((Space)issue).getKey());
        log.debug(">> spaceCreatorChanger (change) > isAffected?");
        if (this.isAffected(issue, sourceUser)) {
            changesTotal = changesTotal + ((Space)issue).getKey() + ", ";
            this.setJobMessage(currentJobId, "Updating creator for space " + ((Space)issue).getKey());
            boolean transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                try {
                    log.debug(">> spaceCreatorChanger (change) > trying to get space");
                    Space space = this.spaceManager.getSpace(((Space)issue).getKey());
                    if (space != null) {
                        log.debug(">> spaceCreatorChanger (change) > trying to update spaceCreator");
                        space.setCreator(targetUser);
                        this.spaceManager.saveSpace(space);
                        log.debug(">> spaceCreatorChanger (change) > success");
                    }
                    return true;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getStackTrace().toString());
                    e.printStackTrace();
                    return false;
                }
            });
            if (transactionResult) {
                changesSuccess = changesSuccess + ((Space)issue).getKey() + ", ";
            } else {
                changesFail = changesFail + ((Space)issue).getKey() + ", ";
            }
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }
}

