/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCreatorChanger
extends BasicContentChanger {
    public static final String NAME = "changeAttachCreator";
    @ComponentImport
    private AttachmentManager attachmentManager;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public AttachmentCreatorChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport TransactionTemplate transactionTemplate) {
        super(pluginSettingsFactory, transactionTemplate);
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            try {
                ContentEntityObject issue = this.pageManager.getById(pissue.getId());
                List<Attachment> attachments = this.getVersionList(issue);
                for (Attachment attachment : attachments) {
                    if (!this.isAffectedAttach(attachment, user)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        });
    }

    private boolean isAffectedAttach(Attachment attachment, ConfluenceUser user) {
        if (attachment != null && attachment.getCreator() != null && attachment.getLastModifier() != null) {
            return attachment.getCreator().equals(user) || attachment.getLastModifier().equals(user);
        }
        return false;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating attachments creator...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        List<Attachment> versionAttachments = this.getVersionList((ContentEntityObject)issue);
        int versionIssuesSize = versionAttachments.size();
        for (Attachment version : versionAttachments) {
            if (!this.isAffectedAttach(version, sourceUser)) continue;
            changesTotal = changesTotal + version.getId() + ", ";
            this.setJobMessage(currentJobId, "Updating creator for version attachment " + version.getId() + "(" + versionAttachments.indexOf(version) + " of " + versionIssuesSize + ")");
            boolean transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                try {
                    ContentEntityObject page = this.pageManager.getById(issue.getId());
                    Attachment entity = this.attachmentManager.getAttachment(version.getId());
                    if (entity.getCreator().equals(sourceUser)) {
                        entity.setCreator(targetUser);
                    }
                    if (entity.getLastModifier().equals(sourceUser)) {
                        entity.setLastModifier(targetUser);
                    }
                    this.pageManager.saveContentEntity(page, (SaveContext)((DefaultSaveContext.Builder)DefaultSaveContext.builder().updateLastModifier(false).suppressAutowatch(true).suppressNotifications(true)).build());
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            });
            if (transactionResult) {
                changesSuccess = changesSuccess + version.getId() + ", ";
                continue;
            }
            changesFail = changesFail + version.getId() + ", ";
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }

    private List<Attachment> getVersionList(ContentEntityObject page) {
        List lastVersionedAttachments = page.getAttachments();
        return lastVersionedAttachments;
    }
}

