define("actonic-gdpr/request-my-data/execute-user", ["jquery", "actonic-gdpr/request-my-data/rest", "actonic-gdpr/core/flags"], function ($, Rest, flag) {
    function Execute() {
        var user = AJS.Meta.get("remote-user");

        this.init = function () {
            getRequest();

            $("#create-user-request").live("click", function (event) {
                event.preventDefault();
                Rest.createRequest(user, function (data) {
                    if (data)
                        flag.simpleSuccess("Request successfully created.");
                    else flag.simpleWarning("Request for this user already exists. You can not create other, while previous request doesn't finish");
                }, function () {
                });
                getRequest();
            });

            $("#cancel-request").live("click", function (event) {
                var requestId = parseInt($(this).attr("data-id"), 10);
                event.preventDefault();
                Rest.cancelRequest(requestId, function (data) {
                    flag.simpleSuccess("Request successfully cancelled.");
                    getRequest();
                })
            });
        };

        function getRequest() {
            Rest.getRequest(user,
                function (data) {
                    if (!data) $("#request-data").html(ACTONIC.GDPR.RMD.create());
                    else {
                        if (data.error)
                            $("#request-data").html(ACTONIC.GDPR.RMD.results_error());
                        else if (data.cancel)
                            $("#request-data").html(ACTONIC.GDPR.RMD.results_cancel());
                        // data.ends will be always, so data.error and data.cancel checking must be first
                        else if (data.ends) {
                            var soyData = {
                                baseUrl: AJS.contextPath()
                            };
                            $("#request-data").html(ACTONIC.GDPR.RMD.results(soyData));
                        }
                        else {
                            var soyData = {
                                data: data
                            }
                            $("#request-data").html(ACTONIC.GDPR.RMD.status(soyData));
                        }
                    }
                }, function () {
                    // TODO
                });
        }
    }

    return new Execute();
})