define("actonic-gdpr/data-level-agreement/overview", ["jquery", "actonic-gdpr/data-level-agreement/intro", "actonic-gdpr/data-level-agreement/rest", "actonic-gdpr/core/flags"], function ($, Intro, Rest, flags) {

    function Overview() {
        this.init = function () {
            getAllRules();

            $("#confirm-delete-rule-dialog-ok-btn").click(function () {
                var ruleId = $("#confirm-delete-rule-dialog").attr("data-rule-id");
                Rest.deleteRule(ruleId,
                    function () {
                        $("#result-table tbody tr[data-rule-id=" + ruleId + "]").remove();
                        flags.showFlag(AJS.I18n.getText("js-dla.overview.rest.delete-rule.info.title"), AJS.I18n.getText("js-dla.overview.rest.delete-rule.info.desc"), "info");
                    },
                    function (error) {
                        flags.showFlag(AJS.I18n.getText("js-dla.overview.rest.delete-rule.error.title"), AJS.I18n.getText("js-dla.overview.rest.delete-rule.error.desc") + " " + JSON.stringify(error), "error");
                    });
                AJS.dialog2("#confirm-delete-rule-dialog").hide();
            });
            $("#confirm-delete-rule-dialog-cancel-btn").click(function () {
                AJS.dialog2("#confirm-delete-rule-dialog").hide();
            });

            $("#run-rule-btn").click(function () {
                runRule($(this).attr("data-rule-id"));
            });

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });
            $('.aui-dialog2-header-close').click(function() {
                AJS.dialog2("#help-dialog").hide();
            });
            $("#show-intro").click(function() {
                AJS.dialog2("#help-dialog").hide();
                Intro.showIntro();
            });

            checkForProperPluginConfiguration();
        }

        function runRule(dataRuleId) {
            Rest.runRule(dataRuleId,
                function (data) {
                    // log.debug("Rest.runRule data = " + JSON.stringify(data));
                    if (data) {
                        var result = AJS.I18n.getText("js-dla.overview.rest.run-rule.result.code-0");
                        if (data.resultCode == 1) result = AJS.I18n.getText("js-dla.overview.rest.run-rule.result.code-1");
                        if (data.resultCode == 2) result = AJS.I18n.getText("js-dla.overview.rest.run-rule.result.code-2");

                        flags.show({
                            type: "success",
                            close: "manual",
                            body: "<p>" + result + "</p>" +
                            "<p>" + data.details + "</p>"
                        });
                    } else {
                        flags.show({
                            type: "info",
                            close: "manual",
                            body: "<p>" + AJS.I18n.getText("js-dla.overview.rest.run-rule.flag.info.title") + "</p>"
                        });
                    }
                },
                function (error) {
                    flags.show({
                        type: "error",
                        close: "manual",
                        body: "<p>" + AJS.I18n.getText("js-dla.overview.rest.run-rule.flag.error.title") + "</p>" +
                        "<p>" + JSON.stringify(error) + "</p>"
                    });
                });
        }

        function checkForProperPluginConfiguration() {
            Rest.getDataRulesConfigurationStatus(
                function (data) {
                    if (!data || data.status == "error") {
                        flags.show({
                            type: "error",
                            close: "manual",
                            body: "<p>" + AJS.I18n.getText("js-dla.overview.rest.get-config-rule.flag.error.title") + "</p>" +
                            "<p><b>" + data.message + "</b></p>" +
                            "<p>" + AJS.I18n.getText("js-dla.overview.rest.get-config-rule.flag.error.desc") + "</p>"
                        });
                    }
                },
                function (error) {
                    log.error("Rest.getDataRulesConfigurationStatus error = " + JSON.stringify(error));
                });
        }

        function getAllRules() {
            $("#result-table tbody tr").remove();
            $("#progress-indicator").show();

            Rest.getAllRules(
                function (data) { // success
                    //log.debug("Rest.getAllRules data = " + JSON.stringify(data));
                    data.forEach(function (item) {
                        var newRow = getTableRowHtml(item);

                        $("#result-table tbody").append(newRow);
                    });

                    $("#progress-indicator").hide();

                    setTableButtonHandlers();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-dla.overview.rest.get-all-rules.flag.error.title"), AJS.I18n.getText("js-dla.overview.rest.get-all-rules.flag.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function setTableButtonHandlers() {
            $(".run-rule-btn").off("click");
            $(".run-rule-btn").on("click", function () {
                runRule($(this).attr("data-rule-id"));
            });

            $(".disable-rule-btn").off("click");
            $(".disable-rule-btn").on("click", function () {
                toggleRule($(this).attr("data-rule-id"));
            });

            $(".clone-rule-btn").off("click");
            $(".clone-rule-btn").on("click", function () {
                cloneRule($(this).attr("data-rule-id"));
            });
            
            $(".delete-rule-btn").off("click");
            $(".delete-rule-btn").on("click", function () {
                deleteRule($(this).attr("data-rule-id"));
            });
        }

        function toggleRule(ruleId) {
            Rest.toggleRule(ruleId,
                function (item) { // success
                    // log.debug("Rest.getAllRules data = " + JSON.stringify(item));
                    var newRow = getTableRowHtml(item);

                    $("#result-table tr[data-rule-id=" + ruleId + "]").replaceWith(newRow);

                    setTableButtonHandlers();
                },
                function (error) {
                    flags.showFlag(AJS.I18n.getText("js-dla.overview.rest.toggle-rule.flag.error.title"), AJS.I18n.getText("js-dla.overview.rest.toggle-rule.flag.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function getTableRowHtml(ruleData) {
            var lastRunDate = "never";
            if (ruleData.extraOptions && ruleData.extraOptions.lastRun && ruleData.extraOptions.lastRun != 0) {
                lastRunDate = moment.unix(ruleData.extraOptions.lastRun / 1000).format("MMMM Do YYYY, h:mm:ss a");
            }

            return ACTONIC.GDPR.DLA.createDataRuleTableRow({
                id: ruleData.id,
                isActive: ruleData.isActive,
                name: ruleData.name,
                cron: ruleData.cron,
                author: ruleData.creator,
                lastRun: lastRunDate
            });
        }

        function cloneRule(dataRuleId) {
            Rest.cloneRule(dataRuleId,
                function (data) {
                    getAllRules();
                },
                function (error) {
                    flags.show({
                        type: "error",
                        close: "manual",
                        body: "<p>" + AJS.I18n.getText("js-dla.overview.rest.run-rule.flag.error.title") + "</p>" +
                        "<p>" + JSON.stringify(error) + "</p>"
                    });
                });
        }

        function deleteRule(ruleId) {
            var name = $("#result-table tbody tr[data-rule-id=" + ruleId + "] .rule-name-container").text();
            $("#confirm-delete-rule-dialog-name").text("'" + name + "'");
            $("#confirm-delete-rule-dialog").attr("data-rule-id", ruleId);

            AJS.dialog2("#confirm-delete-rule-dialog").show();
        }
    }

    return new Overview();
});