define("actonic-gdpr/user-anonymizer/execute",
    ["jquery", "actonic-gdpr/user-anonymizer/intro", "actonic-gdpr/user-anonymizer/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/picker"],
    function ($, Intro, Rest, flags, Picker) {

    function Execute() {
        this.init = function () {
            Rest.getAdditionalAddonsConfig(function (data) {
                var isDigitalSignatureExists = data.digitalSignature !== "undefined" && data.digitalSignature;
                //console.log(isDigitalSignatureExists);

                if (isDigitalSignatureExists) {
                    $("#digital-signature").closest("fieldset").show();
                }

                $("#help-btn").click(function () {
                    AJS.dialog2("#help-dialog").show();
                });

                $("#show-intro").click(function () {
                    AJS.dialog2("#help-dialog").hide();
                    Intro.showIntro();
                });
                $('.aui-dialog2-header-close').click(function() {
                    AJS.dialog2("#help-dialog").hide();
                });

                $("#execute-btn").click(function () {
                    validateContentChanges(function (config) {
                        runContentChanges(config);
                    }, isDigitalSignatureExists);
                });
                $("#get-affected-content-btn").click(function () {
                    validateContentChanges(function (config) {
                        getAffectedContent(config);
                    }, isDigitalSignatureExists);
                });

                $("#run-global-changes-btn").click(function () {
                    validateGlobalChanges(function (config) {
                        runGlobalChanges(config);
                    });
                });

                $("#global-changes-select-all").change(function () {
                    //log.debug("#global-changes-select-all = " + $(this).is(":checked"));
                    if ($(this).is(":checked")) {
                        $("#global-change-delete-from-groups").prop("checked", true);
                        $("#global-change-clear-profile-data").prop("checked", true);
                        $("#global-change-disable-user").prop("checked", true);
                        $("#global-change-publish-event-user").prop("checked", true);
                    } else {
                        $("#global-change-delete-from-groups").prop("checked", false);
                        $("#global-change-clear-profile-data").prop("checked", false);
                        $("#global-change-disable-user").prop("checked", false);
                        $("#global-change-publish-event-user").prop("checked", false);
                    }
                });

                $("#content-changes-select-all").change(function () {
                    //log.debug("#content-changes-select-all = " + $(this).is(":checked"));
                    if ($(this).is(":checked")) {
                        $("#cql-field").prop("checked", true);
                        $("#content-change-remove-from-watchers").prop("checked", true);
                        $("#content-change-remove-mention-user").prop("checked", true);
                        $("#content-change-remove-personal-space").prop("checked", true);
                        $("#content-change-space-creator").prop("checked", true);
                        $("#content-change-page-creator").prop("checked", true);
                        $("#content-change-attach-creator").prop("checked", true);
                        $("#content-change-comment-author").prop("checked", true);
                        $("#content-change-permissions").prop("checked", true);
                        if (isDigitalSignatureExists)
                            $("#digital-signature").prop("checked", true);
                    } else {
                        $("#cql-field").prop("checked", true);
                        $("#content-change-remove-from-watchers").prop("checked", false);
                        $("#content-change-remove-mention-user").prop("checked", false);
                        $("#content-change-remove-personal-space").prop("checked", false);
                        $("#content-change-space-creator").prop("checked", false);
                        $("#content-change-page-creator").prop("checked", false);
                        $("#content-change-attach-creator").prop("checked", false);
                        $("#content-change-comment-author").prop("checked", false);
                        $("#content-change-permissions").prop("checked", false);
                        if (isDigitalSignatureExists)
                            $("#digital-signature").prop("checked", false);
                    }
                });

                Picker.initializeUserPicker("source-user-picker");
                Picker.initializeUserPicker("target-user-picker");
            })
        }

        /*function initializeUserPicker(user) {
            user.auiSelect2({
                placeholder: AJS.I18n.getText("js-anonymizer.execute.placeholder.select-user"),
                dropdownAutoWidth: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/users",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                },
            });
        }*/

        function getAffectedContent(config) {
            $("#content-changes-execution-result-dialog-body").html("Looking for affected issues...");
            AJS.dialog2("#content-changes-execution-result-dialog").show();

            $("#affected-content-table").hide();
            $("#affected-content-table tbody tr").remove();
            $("#affected-content-nothing-to-show").hide();

            $("#content-changes-results-table").hide();
            $("#content-changes-results-nothing-to-show").hide();

            Rest.getAffectedContent(config,
                function (data) {
                    AJS.dialog2("#content-changes-execution-result-dialog").hide();
                    //log.debug("getAffectedContent data = " + JSON.stringify(data));

                    if (data && Array.isArray(data) && data.length > 0) {
                        $("#affected-content-table").show();
                        data.forEach(function (row) {
                            $("#affected-content-table tbody").append(
                                $("<tr/>")
                                    .append($("<td/>").text(getProperTextForChangerName(row.changerName)))
                                    .append($("<td/>").text(row.affectedContent))
                            );
                        });
                    } else {
                        $("#affected-content-nothing-to-show").show();
                    }
                },
                function (error) {
                    log.error("getAffectedContent error = " + JSON.stringify(error.responseText));
                    AJS.dialog2("#content-changes-execution-result-dialog").hide();
                    flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.get-affected.warning.title"), JSON.stringify(error.responseText), "warning");
                });
        }

        function validateContentChanges(successCallback, isDigitalSignatureExists) {
            var sourceUserName = $("#source-user-picker").val();
            if (!sourceUserName) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.to-implement"), "warning");
                return;
            }

            var targetUserName = $("#target-user-picker").val();
            if (!targetUserName) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.whom-implement"), "warning");
                return;
            }

            if (sourceUserName == targetUserName) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.same-users"), "warning");
                return;
            }

            var config = {};
            config.sourceUserName = sourceUserName;
            config.targetUserName = targetUserName;
            config.removeFromWatchers = $("#content-change-remove-from-watchers").is(":checked");
            config.changeMentionUser = $("#content-change-remove-mention-user").is(":checked");
            config.removePersonalSpace = $("#content-change-remove-personal-space").is(":checked");
            config.changeSpaceCreator = $("#content-change-space-creator").is(":checked");
            config.changePageCreator = $("#content-change-page-creator").is(":checked");
            config.changeAttachCreator = $("#content-change-attach-creator").is(":checked");
            config.changeCommentAuthor = $("#content-change-comment-author").is(":checked");
            config.changeUserPermissions = $("#content-change-permissions").is(":checked");
            config.digitalSignature = isDigitalSignatureExists && $("#digital-signature").is(":checked");

            if (!config.removeFromWatchers && !config.changeMentionUser && !config.changeMentionUser
                && !config.removePersonalSpace && !config.changeSpaceCreator
                && !config.changePageCreator && !config.changeAttachCreator
                && !config.changeCommentAuthor && !config.changeUserPermissions && !config.digitalSignature) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.select-option"), "warning");
                return;
            }

            config.cql = $("#cql-field").val();
            Rest.checkCql(config.cql,
                function (data) {

                    if (data.value && data.value != "") {
                        if (data.value != "") {
                            flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.check-cql.error.title"), data.value, "warning");
                            return;
                        } else {
                            flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.check-cql.error.title"), AJS.I18n.getText("js-anonymizer.execute.rest.check-cql.error.desc"), "warning");
                            return;
                        }
                    } else {
                        Rest.checkConfigForContentChanges(config,
                            function (data) {
                                //log.debug("checkConfigForContentChanges data = " + JSON.stringify(data));

                                successCallback(config);
                            },
                            function (error) {
                                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), JSON.stringify(error.responseText), "warning");
                            });
                    }
                },
                function (error) {
                    log.error("checkCql error = " + JSON.stringify(error.responseText));
                    flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), JSON.stringify(error.responseText), "warning");
                });
        }

        function runContentChanges(config) {
            $("#content-changes-execution-result-dialog-body").html("Starting...");
            AJS.dialog2("#content-changes-execution-result-dialog").show();

            $("#affected-content-table").hide();
            $("#affected-content-nothing-to-show").hide();

            $("#content-changes-results-table").hide();
            $("#content-changes-results-table tbody tr").remove();
            $("#content-changes-results-nothing-to-show").hide();

            Rest.runContentChanges(config,
                function (data) {
                    //log.debug("runContentChanges data = " + JSON.stringify(data));
                    var taskId = data;

                    var intervalTask = setInterval(function () {
                        Rest.getTaskStatus(taskId,
                            function (data) {
                                //log.debug("taskId data = " + JSON.stringify(taskId));
                                //log.debug("getTaskStatus data = " + JSON.stringify(data));
                                if (data) {
                                    data = JSON.parse(data);
                                    if (data && data.status == "in progress") {
                                        $("#content-changes-execution-result-dialog-body").html(data.message);
                                    }
                                    if (data && data.status == "done") {
                                        //log.debug("data.message = " + data.message);
                                        $("#content-changes-execution-result-dialog-body").html(data.message);
                                        clearInterval(intervalTask);
                                        AJS.dialog2("#content-changes-execution-result-dialog").hide();

                                        var results = data.results;
                                        //if (data.message !== null && typeof data.message !== 'object') data.message = JSON.parse(data.message);
                                        if (results && Array.isArray(results) && results.length > 0) {
                                            $("#content-changes-results-table").show();
                                            results.forEach(function (row) {
                                                $("#content-changes-results-table tbody").append(
                                                    $("<tr/>")
                                                        .append($("<td/>").text(getProperTextForChangerName(row.changerName)))
                                                        .append($("<td/>").text(row.affectedContent))
                                                        .append($("<td/>").text(row.successfullyChanged))
                                                        .append($("<td/>").text(row.badlyChanged))
                                                );
                                            });
                                        } else {
                                            $("#content-changes-results-nothing-to-show").show();
                                        }
                                    }
                                } else {
                                    $("#content-changes-execution-result-dialog-body").html(data);
                                }
                            },
                            function (error) {
                                log.error("getTaskStatus error = " + JSON.stringify(error.responseText));
                                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.task-status.warning.title"), JSON.stringify(error.responseText), "warning");
                                //clearInterval(intervalTask);
                            });
                    }, 500);
                },
                function (error) {
                    log.error("runContentChanges error = " + JSON.stringify(error.responseText));
                    flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.content-changes.warning.title"), JSON.stringify(error.responseText), "warning");
                });
        }

        function getProperTextForChangerName(changerName) {
            if (changerName == "removeFromWatchers") return AJS.I18n.getText("js-anonymizer.execute.changer-name.remove-from-watchers");
            if (changerName == "changeMentionUser") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-mention-user");
            if (changerName == "removePersonalSpace") return AJS.I18n.getText("js-anonymizer.execute.changer-name.remove-personal-space");
            if (changerName == "changeSpaceCreator") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-space-creator");
            if (changerName == "changePageCreator") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-page-creator");
            if (changerName == "changeAttachCreator") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-attach-creator");
            if (changerName == "changeCommentAuthor") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-comment-author");
            if (changerName == "changeUserPermissions") return AJS.I18n.getText("js-anonymizer.execute.changer-name.change-user-permissions");
            if (changerName == "digitalSignature") return AJS.I18n.getText("js-anonymizer.execute.changer-name.digital-signature");

            return "unknown";
        }

        function validateGlobalChanges(successCallback) {
            var userName = $("#source-user-picker").val();
            if (!userName) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.global.to-implement"), "warning");
                return;
            }
            var targetUserName = $("#target-user-picker").val();

            if (userName == AJS.params.loggedInUser) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.global.no-permission"), "warning");
                return;
            }

            var config = {};
            config.deleteFromGroups = $("#global-change-delete-from-groups").is(":checked");
            config.disable = $("#global-change-disable-user").is(":checked");
            config.clearProfile = $("#global-change-clear-profile-data").is(":checked");
            config.event = $("#global-change-publish-event-user").is(":checked");

            if (!config.deleteFromGroups && !config.disable && !config.clearProfile && !config.event) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.global.select-option"), "warning");
                return;
            }

            if (config.event && !targetUserName) {
                flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.validate.global.to-implement"), "warning");
                return;
            }

            config.userName = userName;
            config.target = targetUserName;

            Rest.checkUserForUpdateRights(userName,
                function (data) {
                    //log.debug("checkUserForUpdateRights data = " + JSON.stringify(data));

                    if (data) {
                        if (!data.canUpdateGroupMembershipForUser || !data.canUpdateUser) {
                            flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.validate.error"), AJS.I18n.getText("js-anonymizer.execute.rest.check-user.warning.external-user"), "warning");

                            return;
                        }
                    }
                    successCallback(config);
                },
                function (error) {
                    log.error("checkUserForUpdateRights error = " + JSON.stringify(error.responseText));
                    flags.showFlag("Validation error", JSON.stringify(error.responseText), "warning");
                }
            );
        }

        function runGlobalChanges(config) {
            //log.debug("runGlobalChanges config = " + JSON.stringify(config));
            $("#execution-result-dialog-body").html("Starting global changes with user... ");
            AJS.dialog2("#execution-result-dialog").show();

            Rest.runGlobalChanges(config,
                function (data) {
                    //log.debug("runGlobalChanges data = " + JSON.stringify(data));
                    $("#execution-result-dialog-body").html(data);

                    setTimeout(function () {
                        AJS.dialog2("#execution-result-dialog").hide();
                        flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.global-changes.info.completed"), data, "info");
                    }, 1000);
                },
                function (error) {
                    AJS.dialog2("#execution-result-dialog").hide();
                    log.error("runGlobalChanges error = " + JSON.stringify(error.responseText));
                    flags.showFlag(AJS.I18n.getText("js-anonymizer.execute.rest.global-changes.error.title"), JSON.stringify(error.responseText), "error");
                }
            );
        }
    }

    return new Execute();
});
