define("actonic-gdpr/announcing/create-edit", ["jquery", "actonic-gdpr/announcing/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/wait-for-element", "actonic-gdpr/core/intro"], function ($, Rest, flags, waitForElement, CoreIntro) {

    function Template() {
        var action = "create";
        var currentAnnouncingId;
        var announcingContent = 'announcing-editor'; // initial value of variable
        var announcingEditor = 'announcing-editor';
        var announcingPage = 'announcing-page';
        var ANNOUNCING_CENTER = 'center';
        var ANNOUNCING_BOTTOM = 'bottom';
        var executeGroupPicker = require("actonic-gdpr/core/picker/group-picker");

        this.init = function () {
            var url = new URL(window.location.href);

            setupIntro();

            $("#help-btn").click(function () {
                AJS.dialog2("#help-dialog").show();
            });

            $("#show-intro-btn").click(function () {
                AJS.dialog2("#help-dialog").hide();
                $("#general-configuration-link").trigger("click");
                CoreIntro.start();
            });

            $("#clean-group-picker-btn").click(function () {
                $("#announcing-group").val("").trigger("change");
            });

            $('#announcing-content').change(function () {
                announcingContent = $('#announcing-content').val();
                if (announcingContent === announcingEditor) {
                    $('#content-page').hide();
                    $('#content-editor').show();
                } else if (announcingContent === announcingPage) {
                    $('#content-editor').hide();
                    $('#content-page').show();
                }
            });

            $(".nav-bar-item").click(function () {
                $(".nav-bar-item").removeClass("nav-active");
                $(".nav-bar-content").hide();
                $(this).addClass("nav-active");
            });

            $("#general-configuration-link").click(function () {
                $("#general-configuration-wrapper").show();
            });

            $("#additional-configuration-link").click(function () {
                $("#additional-configuration-wrapper").show();
            });

            if (url.searchParams.get("action") != null && url.searchParams.get("action") != "") action = url.searchParams.get("action");
            currentAnnouncingId = url.searchParams.get("id");

            if (action == "edit") {
                if (currentAnnouncingId) {
                    waitForElement.waitForIframe("wysiwygTextarea_ifr", function(){
                        getAnnouncing(currentAnnouncingId, function (announcing) {
                            updateNavMenuTitle(announcing);
                            fillAnnouncingForm(announcing);

                            // to fix editor height
                            var minHeight = $("#wysiwygTextarea_ifr")[0].contentWindow.document.body.scrollHeight;
                            if (minHeight < 150) minHeight = 150;
                            $("#wysiwygTextarea_ifr").height(minHeight);
                            AJS.Rte.editorFocus(AJS.Rte.getEditor());
                        });
                    });
                } else {
                    flags.showFlag("Error Loading Data", "Query string parameter 'id' is missed. Unable to load an unknown announcement", "error");
                }
            } else {
                updateNavMenuTitle({});
                executeGroupPicker.initializeGdprGroupPicker($("#announcing-group"));
            }
            $("#announcing-style").on("change", function () {
                if ($("#announcing-style").val() === ANNOUNCING_CENTER) {
                    $("#announcing-style-center-image").show();
                    $("#announcing-style-bottom-image").hide();
                } else if ($("#announcing-style").val() === ANNOUNCING_BOTTOM) {
                    $("#announcing-style-center-image").hide();
                    $("#announcing-style-bottom-image").show();
                }
                $("#announcing-window-size").trigger('change');
            });
            $("#announcing-window-size").on("change", function () {
                var announcingWindowSize = $("#announcing-window-size").val();
                $("div[id^='announcing-window']").hide();
                if ($("#announcing-style").val() === "center") {
                    $("#announcing-window-center-" + announcingWindowSize).show();
                } else if ($("#announcing-style").val() === "bottom") {
                    $("#announcing-window-bottom-" + announcingWindowSize).show();
                } else if ($("#announcing-style").val() === "block-login-form") {
                    $("#announcing-window-block-login-form-" + announcingWindowSize).show();
                }
            });

            $("#announcing-form-dialog-ok-btn").click(function () {
                if (action == "create") {
                    validateForm(function () {
                        createAnnouncing(function (announcingItem) {
                            window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/information-announcing.action"
                        });
                    });
                }
                if (action == "edit") {
                    validateForm(function () {
                        updateAnnouncing(function (announcingItem) {
                            window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/information-announcing.action"
                        });
                    });
                }
            });

            $("#announcing-form-dialog-cancel-btn").click(function () {
                window.location.href = AJS.contextPath() + "/admin/actonic-gdpr/information-announcing.action"
            });

            var todayFrom = new Date();
            todayFrom.setHours(0 ,0);
            var todayTo = new Date();
            todayTo.setHours(23 ,59);

            Calendar.setup({
                firstDay : 1,
                inputField : "announcing-start-date",
                button : "announcing-start-date-button",
                align : "Br",
                singleClick : true,
                showsTime : true,
                useISO8601WeekNumbers : false,
                ifFormat : "%Y-%m-%d %H:%M",
                date : todayFrom
            });

            Calendar.setup({
                firstDay : 1,
                inputField : "announcing-end-date",
                button : "announcing-end-date-button",
                align : "Br",
                singleClick : true,
                showsTime : true,
                useISO8601WeekNumbers : false,
                ifFormat : "%Y-%m-%d %H:%M",
                date : todayTo
            });
        };

        function setupIntro() {
            CoreIntro.init({
                name: "announcing-edit",
                steps: function () {
                    $("#announcing-enabled").parent().attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-enabled"));
                    $("#announcing-start-date").parent().attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-start-date"));
                    $("#announcing-end-date").parent().attr("data-step", "3").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-end-date"));
                    $("#announcing-name").parent().attr("data-step", "4").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-name"));
                    $("#announcing-type").parent().attr("data-step", "5").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-type"));
                    $("#announcing-title").parent().attr("data-step", "6").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-title"));
                    $("#announcing-body-wrapper").attr("data-step", "7").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.announcing-body-wrapper"));
                    $("#announcing-form-dialog-ok-btn").attr("data-step", "8").attr("data-intro", AJS.I18n.getText("js-announcing.edit-page.save-btn"));
                }
            });
        }

        /*function updateNavMenuTitle(announcingItem) {
            var generalConfigurationSubtitle = '';
            if(announcingItem && announcingItem.name) {
                generalConfigurationSubtitle = AJS.I18n.getText("js-announcing.edit-page.text.name.set") + " ";
            } else {
                generalConfigurationSubtitle = AJS.I18n.getText("js-announcing.edit-page.text.name.empty") + " ";
            }

            if(announcingItem && announcingItem.title) {
                generalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.title.set") + " ";
            } else {
                generalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.title.empty") + " ";
            }

            if(announcingItem && announcingItem.body) {
                generalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.main.set") + " ";
            } else {
                generalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.main.empty") + " ";
            }

            $("#general-configuration-link-subtitle").text(generalConfigurationSubtitle);

            var additionalConfigurationSubtitle = "";

            if(announcingItem && announcingItem.group) {
                additionalConfigurationSubtitle = AJS.I18n.getText("js-announcing.edit-page.text.group.set") + " ";
            } else {
                additionalConfigurationSubtitle = AJS.I18n.getText("js-announcing.edit-page.text.group.empty") + " ";
            }

            if(announcingItem && announcingItem.style) {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.display.set") + " ";
            } else {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.display.empty") + " ";
            }

            if(announcingItem && announcingItem.windowSize) {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.window.set") + " ";
            } else {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.window.empty") + " ";
            }

            if(announcingItem && announcingItem.pinned) {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.pinned.set") + " ";
            } else {
                additionalConfigurationSubtitle += AJS.I18n.getText("js-announcing.edit-page.text.pinned.empty") + " ";
            }

            $("#additional-configuration-link-subtitle").text(additionalConfigurationSubtitle);
        }*/

        function updateNavMenuTitle(announcingItem) {
            if (!announcingItem) {
                announcingItem = getAnnouncingRequest();
            }

            var generalConfigurationSubtitle = '';
            var successIcon = "<span class='custom-success-icon custom-icon icon'></span>";
            var errorIcon = "<span class='custom-error-icon custom-icon icon'></span>";
            var warningIcon = "<span class='custom-warning-icon custom-icon icon'></span>";

            if (announcingItem && announcingItem.isActive) {
                generalConfigurationSubtitle = successIcon + AJS.I18n.getText("js-announcing.edit-page.text.status.enabled") + "<br>";
            } else {
                generalConfigurationSubtitle = warningIcon + AJS.I18n.getText("js-announcing.edit-page.text.status.disabled") + "<br>";
            }

            if (announcingItem && announcingItem.name) {
                generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.name.set") + "<br>";
            } else {
                generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.name.empty") + "<br>";
            }

            if (announcingItem && announcingItem.type) {
                switch (announcingItem.type) {
                    case 'required':
                        generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.type.required") + "<br>";
                        break;
                    case 'optional':
                        generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.type.optional") + "<br>";
                        break;
                }
            } else {
                generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.name.empty") + "<br>";
            }

            if (announcingItem && announcingItem.title) {
                generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.title.set") + "<br>";
            } else {
                generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.title.empty") + "<br>";
            }

            if (announcingItem && announcingItem.body) {
                generalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.main.set") + "<br>";
            } else {
                generalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.main.empty") + "<br>";
            }

            $("#general-configuration-link-subtitle").html(generalConfigurationSubtitle);

            var additionalConfigurationSubtitle = "";

            if (announcingItem && announcingItem.group) {
                additionalConfigurationSubtitle = successIcon + AJS.I18n.getText("js-announcing.edit-page.text.group.set") + "<br>";
            } else {
                additionalConfigurationSubtitle = warningIcon + AJS.I18n.getText("js-announcing.edit-page.text.group.empty") + "<br>";
            }

            if (announcingItem && announcingItem.style) {
                if (announcingItem.style == 'center') {
                    additionalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.display.center") + "<br>";
                } else if (announcingItem.style == 'bottom') {
                    additionalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.display.bottom") + "<br>";
                }
            } else {
                additionalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.display.empty") + "<br>";
            }

            if (announcingItem && announcingItem.windowSize) {
                var selectedSize = '';
                switch (announcingItem.windowSize) {
                    case 'small':
                        selectedSize = AJS.I18n.getText("vm-announcing.dialog.field.window-small-label");
                        break;
                    case 'medium':
                        selectedSize = AJS.I18n.getText("vm-announcing.dialog.field.window-medium-label");
                        break;
                    case 'large':
                        selectedSize = AJS.I18n.getText("vm-announcing.dialog.field.window-large-label");
                        break;
                    case 'xlarge':
                        selectedSize = AJS.I18n.getText("vm-announcing.dialog.field.window-xlarge-label");
                        break;
                }
                additionalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.window.set") + " " + selectedSize.toLowerCase() + "<br>";
            } else {
                additionalConfigurationSubtitle += errorIcon + AJS.I18n.getText("js-announcing.edit-page.text.window.empty") + "<br>";
            }

            if (announcingItem && announcingItem.pinned) {
                additionalConfigurationSubtitle += successIcon + AJS.I18n.getText("js-announcing.edit-page.text.pinned.set") + "<br>";
            } else {
                additionalConfigurationSubtitle += warningIcon + AJS.I18n.getText("js-announcing.edit-page.text.pinned.empty") + "<br>";
            }

            $("#additional-configuration-link-subtitle").html(additionalConfigurationSubtitle);
        }

        function getAnnouncingRequest() {
            var pageId = $("#announcing-page").val() ? $("#announcing-page").val() : 0;
            var body = $("#wysiwygTextarea_ifr").contents().find("body").html();

            var request = {
                isActive: $("#announcing-enabled").prop("checked"),
                startDate: $("#announcing-start-date").val().trim(),
                endDate: $("#announcing-end-date").val().trim(),
                name: $("#announcing-name").val(),
                type: $("#announcing-type").val(),
                style: $("#announcing-style").val(),
                group: $("#announcing-group").val(),
                isQuestionnaire: $("#announcing-questionnaire").prop("checked"),
                isAnonymous: $("#announcing-anonymous").prop("checked"),
                windowSize: $("#announcing-window-size").val(),
                accept: $("#announcing-accept").val(),
                decline: $("#announcing-decline").val(),
                title: $("#announcing-title").val(),
                isPinned: $("#announcing-pinned").prop("checked"),
                content: $("#announcing-content").val(),
                pageId: pageId,
                body: body
            };

            return request;
        }

        function createAnnouncing(successCallback) {
            var request = getAnnouncingRequest();

            Rest.createAnnouncing(request,
                function (announcingItem) { // success
                    //log.debug("Rest.createAnnouncing data = " + JSON.stringify(announcingItem));
                    successCallback(announcingItem);
                },
                function (error) { // error
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.create-announcing.error.title"), AJS.I18n.getText("js-announcing.template.rest.create-announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function updateAnnouncing(successCallback) {
            var request = getAnnouncingRequest();
            var id = $("#announcing-id").val();

            Rest.updateAnnouncing(id, request,
                function (announcingItem) { // success
                    //log.debug("Rest.updateAnnouncing data = " + JSON.stringify(announcingItem));
                    successCallback(announcingItem);
                },
                function (error) { // error
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.update-announcing.error.title"), AJS.I18n.getText("js-announcing.template.rest.update-announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function getAnnouncing(id, successCallback) {
            Rest.getAnnouncing(id,
                function (announcingItem) { // success
                    //log.debug("Rest.getAnnouncing data = " + JSON.stringify(announcingItem));
                    successCallback(announcingItem);
                },
                function (error) { // error
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.get-announcing.error.title"), AJS.I18n.getText("js-announcing.template.rest.get-announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function validateForm(successCallback) {
            var isEverythingOK = true;
            var announcingBody = $("#wysiwygTextarea_ifr").contents().find("body").text();
            var announcingPageId = $("#announcing-page").val();
            if ($("#announcing-name").val() == "") {
                isEverythingOK = false;
                flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.name"), "warning");
            } else {
                if ($("#announcing-name").val().length > 128) {
                    isEverythingOK = false;
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.name.size"), "warning");
                }
            }
            if ($("#announcing-title").val() == "") {
                isEverythingOK = false;
                flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.title"), "warning");
            } else {
                if ($("#announcing-title").val().length > 128) {
                    isEverythingOK = false;
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.title.size"), "warning");
                }
            }
            if (announcingContent == "announcing-page" && announcingPageId == "") {
                isEverythingOK = false;
                flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.page"), "warning");
            }
            if (announcingContent == "announcing-editor" && announcingBody == "") {
                isEverythingOK = false;
                flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.text"), "warning");
            }

            var startDateStr = $("#announcing-start-date").val().trim();
            var endDateStr = $("#announcing-end-date").val().trim();
            var startDate;
            var endDate;
            if (startDateStr != "") {
                startDate = moment(startDateStr, 'YYYY-MM-DD HH:mm', true);
                if (!startDate.isValid()) {
                    isEverythingOK = false;
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.announcing-start-date-format.desc"), "warning");
                }
            }
            if (endDateStr != "") {
                endDate = moment(endDateStr, 'YYYY-MM-DD HH:mm', true);
                if (!endDate.isValid()) {
                    isEverythingOK = false;
                    flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.announcing-end-date-format.desc"), "warning");
                }
            }
            if (startDate && endDate && startDate >= endDate) {
                isEverythingOK = false;
                flags.showFlag(AJS.I18n.getText("js-announcing.template.validate.error"), AJS.I18n.getText("js-announcing.template.validate.announcing-start-greater-end-date.desc"), "warning");
            }

            if (announcingContent == announcingEditor) {
                Rest.checkHtmlValid(announcingBody,
                    function (data) { // success
                        //log.debug("Rest.getAnnouncing data = " + JSON.stringify(data));
                        if (data && data.status) {
                            //flags.showFlag("Validation error", "Announcing Text contains not valid HTML tags", "warning");
                            if (isEverythingOK) successCallback();
                        } else {
                            flags.showFlag("Validation error", AJS.I18n.getText("js-announcing.template.validate.html"), "warning");
                        }
                    },
                    function (error) { // error
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.check.error.title"), AJS.I18n.getText("js-announcing.template.rest.check.error.desc") + " " + JSON.stringify(error.responseText), "error");
                    });
            } else if (announcingContent == announcingPage) {
                Rest.checkPageValid(announcingPageId,
                    function (data) { // success
                        //log.debug("Rest.getAnnouncing data = " + JSON.stringify(data));
                        if (data && data.status) {
                            //flags.showFlag("Validation error", "Announcing Text contains not valid HTML tags", "warning");
                            if (isEverythingOK) successCallback();
                        } else {
                            flags.showFlag("Validation error", AJS.I18n.getText("js-announcing.template.validate.page-validate"), "warning");
                        }
                    },
                    function (error) { // error
                        flags.showFlag(AJS.I18n.getText("js-announcing.template.rest.check.error.title"), AJS.I18n.getText("js-announcing.template.rest.check.error.desc") + " " + JSON.stringify(error.responseText), "error");
                    });
            }


        }

        function fillAnnouncingForm(announcingItem) {
            document.getElementById("announcing-enabled").checked = announcingItem.isActive;
            document.getElementById("announcing-anonymous").checked = announcingItem.anonymous;

            announcingContent = announcingItem.content.toLowerCase();
            $("#announcing-id").val(announcingItem.id);
            $("#announcing-start-date").val(announcingItem.startDate);
            $("#announcing-end-date").val(announcingItem.endDate);
            $("#announcing-name").val(announcingItem.name);
            $("#announcing-type").val(announcingItem.type);
            $("#announcing-style").val(announcingItem.style);
            if(announcingItem.style === ANNOUNCING_BOTTOM) {
                $("#announcing-style-center-image").hide();
                $("#announcing-style-bottom-image").show();
            }
            $("#announcing-group").val(announcingItem.group);
            executeGroupPicker.initializeGdprGroupPicker($("#announcing-group"));
            $("#announcing-questionnaire").prop("checked", announcingItem.questionnaire);
            if(announcingItem.windowSize)
                $("#announcing-window-size").val(announcingItem.windowSize).trigger("change");
            else
                $("#announcing-window-size").val("medium").trigger("change");

            if(announcingItem.accept)
                $("#announcing-accept").val(announcingItem.accept);
            else
                $("#announcing-accept").val("Accept");

            if(announcingItem.decline)
                $("#announcing-decline").val(announcingItem.decline);
            else
                $("#announcing-decline").val("Decline");
            $("#announcing-pinned").prop("checked", announcingItem.pinned);
            $("#announcing-title").val(announcingItem.title);
            $("#announcing-content").val(announcingItem.content);
            $("#announcing-page").val(announcingItem.pageId);
            var sample = $("#wysiwygTextarea_ifr").contents().find("body").length;
            $("#wysiwygTextarea_ifr").contents().find("body").html(announcingItem.body);

            $("#announcing-form-dialog-ok-btn").text(AJS.I18n.getText("js-create-edit-announcing.update-btn"));
            $("#announcing-form-dialog-header").text(AJS.I18n.getText("js-create-edit-announcing.edit-btn"));

            if (announcingItem.pageId) {
                $('#content-editor').hide();
                $('#content-page').show();
            }

            checkIfAnonymousSelected();
        }

        $("#announcing-registered").on("change", function () {
            document.getElementById('s2id_announcing-group').style.pointerEvents = 'auto';
            $("#s2id_announcing-group .select2-choice").removeClass("disabled-picker");
        });


        $('#announcing-anonymous').on('change',function(){
            document.getElementById('s2id_announcing-group').style.pointerEvents = 'none';
            $("#announcing-group").val(null).trigger("change");
            $("#s2id_announcing-group .select2-choice").addClass("disabled-picker");
        });

        function checkIfAnonymousSelected() {
            if($('#announcing-anonymous').is(':checked')) {
                document.getElementById('s2id_announcing-group').style.pointerEvents = 'none';
                $("#s2id_announcing-group .select2-choice").addClass("disabled-picker");
            }

        }
    }

    return new Template();
});

