define("gdpr/data-cleaner/rules", ["jquery", "gdpr/data-cleaner/rules/rest", "actonic-gdpr/core/flags", "actonic-gdpr/core/tippy",
        "gdpr/core/log", "actonic-gdpr/domReady", "gdpr/core/element-highlighter", "gdpr/core/utils",
        "gdpr/data-cleaner/builtin-rules", "actonic-gdpr/core/picker"],
    function ($, ruleRest, flags, Tippy, log, domReady, coreHighlighter, coreUtils, dataCleanerBuiltinRules, Picker) {
        function DataCleanerRules() {
            var templateId = coreUtils.getCurrentUrlParameterByName("id");
            var currentRules;
            var isInitSearchType = true;

            this.init = function () {
                dataCleanerBuiltinRules.init({
                    onRequireRulesRefreshHandler: getRulesForTemplate
                });

                getRulesForTemplate();

                $("#add-rule-new").on("click", function () {
                    initDialog({templateId: coreUtils.getCurrentUrlParameterByName("id")});
                });

                //initRecentIssuesPicker("ticket-selector");

                $("#show-dialog-for-issue-and-rules-matches-btn").on("click", function () {
                    AJS.dialog2("#check-issue-and-rules-matches-dialog").show();
                });
                $("#check-issue-and-rules-matches-cancel-btn").on("click", function () {
                    AJS.dialog2("#check-issue-and-rules-matches-dialog").hide();
                });

                $("#check-issue-and-rules-matches-btn").on("click", function () {
                    checkIssueAndRulesMatches();
                });
            };

            function checkIssueAndRulesMatches() {
                $("#check-issue-and-rules-matches-results").empty();

                var request = {
                    templateId: templateId,
                    issueKey: $("#ticket-selector").val()
                };

                //log.debug(JSON.stringify(request));

                $.ajax({
                    type: "POST",
                    url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/check-match",
                    data: request,
                    success: function (data) {
                        //log.debug(JSON.stringify(data));
                        if (data && data.length > 0) {
                            data.forEach(function (item) {
                                var ruleName = getRuleNameById(item.ruleId);
                                if (ruleName) {
                                    $("#check-issue-and-rules-matches-results").append(
                                        $("<li/>").text(AJS.I18n.getText("js-data-clean.rules.text.check-rules", item.object, ruleName))
                                        // $("<li/>").text("'" + item.object + "' field falls under '" + ruleName + "' rule")
                                    );
                                }
                            });
                        } else {
                            $("#check-issue-and-rules-matches-results").text(AJS.I18n.getText("js-data-clean.rules.text.check-rules.no-match"));
                        }
                    },
                    error: function (xhr, textStatus, errorThrown) {
                    }
                })
            }

            function getRuleNameById(ruleId) {
                //log.debug("currentRules = " + JSON.stringify(currentRules));
                if (currentRules) {
                    var currentRule = currentRules.find(function (currentRule) {
                        return currentRule.id == ruleId;
                    });
                    if (currentRule) return currentRule.name;
                }
            }

            function initDialog(params) {
                initRuleDialog(function () {
                    $("#save-rule").on("click", onRuleSaveBtnClickHandler);
                    $("#search-type").on("change", function () {
                        onSearchTypeChangeHandler($(this).val());
                    });
                    $("#replace-type").on("change", function () {
                        onReplaceTypeChangeHandler(this);
                    });
                    Tippy.triggeredByHover("#replace-type-symbol-trigger", "#replace-type-symbol-image");
                    Tippy.triggeredByHover("#replace-type-symbol-respect-string-trigger", "#replace-type-symbol-respect-string-image");
                    loadRuleDialogContent(params)
                });
            }

            function initRecentIssuesPicker(selectorId) {
                AJS.$("#" + selectorId).auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rules.placeholder.recent-issue"),
                    formatResult: function (state) {
                        if (!state.id) return state.text; // optgroup
                        return state.text;
                    },
                    formatSelection: function (state) {
                        if (!state.id) return state.text; // optgroup
                        return state.text;
                    },
                    dropdownParent: $("#check-issue-and-rules-matches-dialog .aui-dialog2-content"),
                    ajax: {
                        type: "GET",
                        cache: true,
                        dataType: 'json',
                        url: AJS.contextPath() + "/rest/quicksearch/1.0/productsearch/search",
                        data: function (term) {
                            return {q: term};
                        },
                        results: function (data) {
                            var sections = data;//[0].issues;
                            var issuesSection = sections.find(function (item) {
                                return item.id == "quick-search-issues";
                            });

                            var results = [];
                            $.each(issuesSection.items, function (index, item) {
                                var dropBoxItemContent = "<img class=\"icon\" src=\"" + item.avatarUrl + "\">  " + item.subtitle + " - " + item.title;
                                results.push({id: item.subtitle, text: dropBoxItemContent});
                            });
                            return {
                                results: results
                            };
                        }
                    }
                });
            }

            function loadRuleDialogContent(dialogContent) {
                //log.debug("loadRuleDialogContent dialogContent = " + JSON.stringify(dialogContent));

                if (dialogContent.id) {
                    $("#id").val(dialogContent.id)
                } else {
                    $("#id").val("")
                }
                if (dialogContent.templateId) {
                    $("#templateId").val(dialogContent.templateId)
                } else {
                    $("#templateId").val("")
                }
                if (dialogContent.name) {
                    $("#rule-name").val(dialogContent.name)
                } else {
                    $("#rule-name").val("")
                }
                if (dialogContent.searchType) {
                    $("#search-type").val(dialogContent.searchType)
                } else {
                    $("#search-type").val("plain");
                }
                if (dialogContent.searchString) {
                    $("#search-string").val(dialogContent.searchString)
                } else {
                    $("#search-string").val("")
                }
                if (dialogContent.replaceType) {
                    $("#replace-type").val(dialogContent.replaceType);
                } else {
                    $("#replace-type").val("none").trigger("change");
                }
                if (dialogContent.replaceString) {
                    $("#replace-string").val(dialogContent.replaceString)
                } else {
                    $("#replace-string").val("")
                }

                $("#search-type").trigger("change");
                $("#replace-type").trigger("change");

                AJS.dialog2("#rule-dialog").show();
            }

            // function onSearchTypeChangeHandler(currentValue) {
            //     var previousVal = $("#search-string").val();
            //     if (isInitSearchType) {
            //         isInitSearchType = false;
            //     } else {
            //         previousVal = "";
            //         if (currentValue == "user") {
            //             $("#replace-string").val("");
            //         }
            //     }
            //     var parent = $("#search-string").parent();
            //     $("#search-string").remove();
            //     $("#s2id_search-string").remove();
            //     $(parent).prepend("<input type=\"text\" class=\"text\" id=\"search-string\">");
            //     $("#search-string").val(previousVal);
            //     $("#replace-type").prop('disabled', false);
            //
            //     if (currentValue == "user") {
            //         $("#replace-type").val("user").prop("disabled", true).trigger("change");
            //         Picker.initializeUserPicker($("#search-string"));
            //     } else {
            //         if ($("#replace-type").val() == "user" || !$("#replace-type").val()) {
            //             //log.debug("none should be placed");
            //             $("#replace-type").val("none").trigger("change");
            //             $("#replace-string").val("");
            //         }
            //     }
            // }

            function onSearchTypeChangeHandler(currentValue) {
                var previousVal = $("#search-string").val();
                if (isInitSearchType) {
                    isInitSearchType = false;
                } else {
                    previousVal = "";
                    if (currentValue == "user" || currentValue == "any-user") {
                        $("#replace-string").val("");
                        $("#s2id_replace-type a.select2-choice").addClass("disabled-picker");
                    } else {
                        $("#s2id_replace-type a.select2-choice").removeClass("disabled-picker");
                    }
                }
                var parent = $("#search-string").parent();
                $("#search-string").remove();
                $("#s2id_search-string").remove();
                $(parent).prepend("<input type=\"text\" class=\"text\" id=\"search-string\">");
                $("#search-string").val(previousVal);
                $("#replace-type").prop('disabled', false);

                $(".field-group-search-string").show();
                $('#rule-dialog .description-for-user-type, #rule-dialog .description-for-text-type').hide();
                if (currentValue == "user" || currentValue == "any-user") {
                    $('#rule-dialog .description-for-user-type').show();
                    $("#replace-type").val("user").prop("disabled", true).trigger("change");
                    if (currentValue == "user")
                        initUserSelector("search-string", previousVal, false);
                    else
                        $(".field-group-search-string").hide();
                } else {

                    $('#rule-dialog .description-for-text-type').show();
                    if ($("#replace-type").val() == "user" || !$("#replace-type").val()) {
                        //log.debug("none should be placed");
                        $("#replace-type").val("none").trigger("change");
                        $("#replace-string").val("");
                    }
                }
            }

            function onReplaceTypeChangeHandler(linkToElement) {
                var previousVal = $("#replace-string").val();
                var parent = $("#replace-string").parent();
                $("#replace-string").remove();
                $("#s2id_replace-string").remove();
                $(parent).prepend("<input type=\"text\" class=\"text\" id=\"replace-string\">");

                var replaceTypeValue = $("#replace-type").find("option:selected").val();
                if (replaceTypeValue == "plain-text")
                    $("#replace-string").val(previousVal);

                if (replaceTypeValue == "plain-text" || replaceTypeValue == "user") {
                    $("#replace-string").removeAttr("disabled");
                } else {
                    $("#replace-string").attr("disabled", "disabled");
                }

                if (replaceTypeValue == "symbol") {
                    $("#replace-type-symbol-trigger").show();
                    $("#replace-type-symbol-respect-string-trigger").hide();
                } else if (replaceTypeValue == "symbol-respect-string") {
                    $("#replace-type-symbol-trigger").hide();
                    $("#replace-type-symbol-respect-string-trigger").show();
                } else {
                    $("#replace-type-symbol-trigger").hide();
                    $("#replace-type-symbol-respect-string-trigger").hide();
                }

                if (replaceTypeValue == "user") {
                    initUserSelector("replace-string", previousVal, false);
                }
            }

            function initUserSelector(selectorId, currentUserName) {
                //log.debug("selectorId = " + selectorId + " ; currentUserName = " + currentUserName);

                var parent = $("#" + selectorId).parent();
                $("#" + selectorId).remove();
                $("#s2id_" + selectorId).remove();
                $(parent).prepend("<input type=\"text\" class=\"text\" id=\"" + selectorId + "\">");

                AJS.$("#" + selectorId).auiSelect2({
                    placeholder: AJS.I18n.getText("js-data-clean.rp.text.select-user"),
                    allowClear: true,
                    multiple: false,
                    ajax: {
                        type: "GET",
                        cache: true,
                        dataType: 'json',
                        url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/picker/user",
                        data: function (term) {
                            return {
                                query: term
                            };
                        },
                        results: function (data) {
                            var results = [];
                            $.each(data, function (index, item) {
                                results.push({id: item.id, text: item.text});
                            });
                            return {
                                results: results
                            };
                        }
                    },
                    initSelection: function (element, callback) {
                        //log.debug("initSelection currentUserName = " + JSON.stringify(currentUserName));
                        //log.debug("initSelection initialValues = " + JSON.stringify(initialValues));

                        if (currentUserName) {
                            callback({id: currentUserName, text: currentUserName});
                        }
                    }
                });

                if (currentUserName) {
                    //log.debug("set initialNames = " + JSON.stringify(currentUserName));

                    $("#" + selectorId).val(currentUserName).trigger("change");
                }
            }

            function prepareRuleRequest() {
                var request = {
                    templateId: $("#templateId").val(),
                    enabled: true,
                    name: $("#rule-name").val(),
                    searchType: $("#search-type").val(),
                    searchString: $("#search-string").val(),
                    replaceType: $("#replace-type option:selected").val(),
                    replaceString: $("#replace-string").val()
                };
                return request;
            }

            function validateRuleRequestData(request, successCallback) {
                var validationSuccess = true;
                var validationErrorMessage = "";

                if (!request.name) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.request.data-rule") + "</li>";
                    coreHighlighter.redBorder("#rule-name");
                    validationSuccess = false;
                }

                if ((request.searchType == "plain" || request.searchType == "regex") && !request.searchString) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.request.search-rule") + "</li>";
                    coreHighlighter.redBorder("#search-string");
                    validationSuccess = false;
                }

                if (request.replaceType == "plain-text" && !request.replaceString) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.request.replace-rule") + "</li>";
                    coreHighlighter.redBorder("#replace-string");
                    validationSuccess = false;
                }

                if (request.searchType == "user" && !request.searchString) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.request.source-user") + "</li>";
                    coreHighlighter.redBorder("#s2id_search-string");
                    validationSuccess = false;
                }

                if (request.replaceType == "user" && !request.replaceString) {
                    validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.request.target-user") + "</li>";
                    coreHighlighter.redBorder("#s2id_replace-string");
                    validationSuccess = false;
                }

                if (validationSuccess) {
                    if (request.searchType == "regex" && request.searchString) {
                        //log.debug("request.searchString = " + JSON.stringify(request.searchString));
                        isRegexValid(request.searchString,
                            function () {
                                successCallback();
                            },
                            function (errorData) {
                                var errorDataObj = JSON.parse(errorData);
                                validationErrorMessage += "<li>" + AJS.I18n.getText("js-data-clean.rules.text.regex-error") + "</li>";
                                coreHighlighter.redBorder("#search-string");
                                flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "<ul>" + errorDataObj.errorMsg + "</ul>", "warning");
                            });
                    } else {
                        // AJS.I18n.getText("js-data-clean.build-ins.rest.announcing.success.desc")
                        successCallback();
                    }
                } else {
                    flags.showFlag(AJS.I18n.getText("warning.main.validation-error"), "<ul>" + validationErrorMessage + "</ul>", "warning");
                }
            }

            function isRegexValid(regexString, successCallback, failCallback) {
                ruleRest.validateRegex(regexString,
                    function () {
                        successCallback();
                    }, function (errorMsg) {
                        failCallback(errorMsg);
                    });
            }

            function onRuleSaveBtnClickHandler() {
                var request = prepareRuleRequest();
                validateRuleRequestData(request, function () {
                    //log.debug("onRuleSaveBtnClickHandler request = " + JSON.stringify(request));

                    var id = $("#id").val();
                    if (id && id >= 0) {
                        ruleRest.update(id, request, function () {
                            closeRuleDialog();
                            getRulesForTemplate();
                            flags.simpleSuccess(AJS.I18n.getText("js-data-clean.rules.success"));
                        }, function (xhr) {
                            log.error(xhr);
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.text.something-wrong"));
                        })
                    } else {
                        ruleRest.create(request, function () {
                            closeRuleDialog();
                            getRulesForTemplate();
                            flags.simpleSuccess(AJS.I18n.getText("js-data-clean.rules.created"));
                        }, function (xhr) {
                            log.error(xhr);
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.text.something-wrong"));
                        })
                    }
                });
            }

            function initRuleDialog(successCallback) {
                $("#rule-dialog-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.newDialogTemplate({
                    baseUrl: AJS.contextPath()
                }));
                $("#search-type").auiSelect2({
                    minimumResultsForSearch: -1,
                    width: 'resolve',
                    dropdownCssClass: 'custom-select2-dropdown'
                });
                $("#replace-type").auiSelect2({
                    minimumResultsForSearch: -1,
                    width: 'resolve',
                    dropdownCssClass: 'custom-select2-dropdown'
                });

                $("#rule-dialog .aui-dialog2-header-close").on("click", function () {
                    closeRuleDialog();
                });

                successCallback();
            }

            function initButtonEvents() {
                $(".edit-data-rule-action").off("click");
                $(".edit-data-rule-action").on("click", function () {
                    isInitSearchType = true;
                    ruleRest.getRule($(this).attr("data-id"), function (data) {
                        initDialog(data)
                    }, function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.warning.getRule"));
                    })
                });

                $(".delete-data-rule-action").off("click");
                $(".delete-data-rule-action").on("click", function () {
                    ruleRest.delete($(this).attr("data-id"), function () {
                        getRulesForTemplate();
                        flags.simpleSuccess(AJS.I18n.getText("js-data-clean.rules.deleted"));
                    }, function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.warning.delete"));
                    })
                });

                $(".clone-data-rule-action").off("click");
                $(".clone-data-rule-action").on("click", function () {
                    ruleRest.getRule($(this).attr("data-id"), function (data) {
                        ruleRest.create(data, function () {
                            getRulesForTemplate();
                            flags.simpleSuccess(AJS.I18n.getText("js-data-clean.rules.cloned"));
                        }, function (xhr) {
                            log.error(xhr);
                            flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.warning.create"));
                        })
                    }, function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.warning.getRule"));
                    })
                });

                $(".enable-disable-data-rule-action").off("click");
                $(".enable-disable-data-rule-action").on("click", function () {
                    var changedState = $(this).attr("data-value") === "true" ? false : true;
                    ruleRest.changeState($(this).attr("data-id"), changedState, function () {
                        getRulesForTemplate();

                        var message = changedState ? AJS.I18n.getText("js-data-clean.rules.text.enabled") : AJS.I18n.getText("js-data-clean.rules.text.disabled");
                        flags.simpleSuccess(message);
                    }, function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.text.something-wrong"));
                    })
                })
            }

            function closeRuleDialog() {
                AJS.dialog2("#rule-dialog").hide();
                $("#rule-dialog-placeholder").html("");
            }

            function getRulesForTemplate() {
                var successIcon = "<span class='custom-success-icon custom-icon icon'></span>";
                var errorIcon = "<span class='custom-error-icon custom-icon icon'></span>";
                var warningIcon = "<span class='custom-warning-icon custom-icon icon'></span>";

                var templateId = coreUtils.getCurrentUrlParameterByName("id");
                if (templateId) {
                    ruleRest.getRulesForTemplate(templateId, function (rulesData) {
                        var enabledRules = rulesData.filter(function (rule) {
                            return rule.enabled;
                        });

                        // log.debug("getRulesForTemplate data = " + JSON.stringify(rulesData));
                        if (rulesData.length <= 0) {
                            $("#data-rules-link-subtitle").html(errorIcon + AJS.I18n.getText("js-data-clean.rules.text.no-data-rules-created"));
                            $("#rule-table-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.noResults);
                        } else {
                            $("#rule-table-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.results({data: rulesData}));
                            if ($("#has-task").val() === "false") $("#rules .aui-dropdown2-trigger").show();
                            initButtonEvents();

                            if (enabledRules.length > 0) {
                                $("#data-rules-link-subtitle").html(successIcon + enabledRules.length + " " + AJS.I18n.getText("js-data-clean.rules.text.rules-enabled"));
                            } else {
                                $("#data-rules-link-subtitle").html(errorIcon + AJS.I18n.getText("js-data-clean.rules.text.no-data-rules-enabled"));
                            }
                        }
                    });
                } else {
                    $("#rule-table-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.noResults);
                }
            }
        }

        return new DataCleanerRules();
    });
