define("gdpr/data-cleaner/result/rest", ["jquery", "gdpr/core/log"], function ($, log) {
    function Rest() {
        this.getLastExecutions = function(templateId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/" + templateId,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };
        this.getTaskById = function(taskId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-template/task/" + taskId,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };
        this.getTaskResults = function(request, successCallback, errorCallback) {
            //log.debug("getTaskResults request = " + JSON.stringify(request));
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/results",
                data: request,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };
        this.customAnonymization = function(request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/anonymize",
                data: request,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };
        this.getCSVExportTask = function(request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/data-cleaner-result/export",
                data: request,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (response, status, xhr) {
                    var filename = xhr.getResponseHeader('content-disposition').split('filename=')[1].split(';')[0];
                    if (typeof successCallback === "function") successCallback(response, filename);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        };
    }

    return new Rest();
})
