/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import de.actonic.gdpr.shared.general.manager.IGDPRPluginLicenseManager;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class GDPRPluginLicenseManager
implements IGDPRPluginLicenseManager {
    private Option<PluginLicense> pluginLicenseOption;
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    public GDPRPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean isLicenseDefined() {
        this.pluginLicenseOption = this.pluginLicenseManager.getLicense();
        return this.pluginLicenseOption.isDefined();
    }

    public boolean isLicenseEvaluation() {
        PluginLicense license = (PluginLicense)this.pluginLicenseOption.get();
        return license.isEvaluation();
    }

    public Date getExpiryDate() {
        PluginLicense license = (PluginLicense)this.pluginLicenseOption.get();
        Option expiryDateOption = license.getExpiryDate();
        return expiryDateOption.isDefined() ? ((DateTime)expiryDateOption.get()).toDate() : null;
    }
}

