define("gdpr/core/user-activity", [], function () {
    function UserActivity() {
        var _this = this;
        var IDLE_TIMEOUT = 120; // seconds before stop tracking
        var _idleSecondsCounter = 0;
        var _stopTracking = false;
        var onUserLeft;
        var onUserReturnBack;

        /*
            Usage example:
            var userActivityRef = UserActivity.init({
                secondsBeforeIdle: 60, // 60 by default
                onUserLeft: function() {
                    // on idle
                },
                onUserReturnBack: function() {
                    // on become active again
                }
            });

            // check user activity state in any place
            log.debug("userActivityRef = " + userActivityRef.isUserActive());
         */
        this.init = function (config) {
            if (typeof config["onUserLeft"] === "function")  onUserLeft = config["onUserLeft"];
            if (typeof config["onUserReturnBack"] === "function")  onUserReturnBack = config["onUserReturnBack"];
            if (config["secondsBeforeIdle"]) IDLE_TIMEOUT = config["secondsBeforeIdle"];

            document.addEventListener("mousemove", resetTimer);
            document.addEventListener("mousedown", resetTimer);
            document.addEventListener("touchstart", resetTimer);
            document.addEventListener("click", resetTimer);
            document.addEventListener("keypress", resetTimer);
            window.addEventListener("scroll", resetTimer, true);

            window.setInterval(checkIdleTime, 1000);

            return _this;
        };

        this.isUserActive = function () {
            return _idleSecondsCounter <= IDLE_TIMEOUT;
        };

        function resetTimer() {
            _idleSecondsCounter = 0;
        }

        function checkIdleTime() {
            _idleSecondsCounter++;

            // log.debug("_stopTracking = " + _stopTracking + " ; " + "_idleSecondsCounter = " + _idleSecondsCounter);
            if (_idleSecondsCounter >= IDLE_TIMEOUT) {
                if (!_stopTracking) {
                    _stopTracking = true;
                    if (typeof onUserLeft === "function") onUserLeft();
                }
            } else {
                if (_stopTracking) { // if return from idle state
                    _stopTracking = false;
                    if (typeof onUserReturnBack === "function") onUserReturnBack();
                }
            }
        }
    }

    return new UserActivity();
});
