/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.manager;

import com.google.common.collect.Lists;
import de.actonic.gdpr.newDC.ao.TemplateDCEntity;
import de.actonic.gdpr.newDC.dao.TemplateDCDao;
import de.actonic.gdpr.shared.general.manager.IGDPRStreamExportManager;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.newDC.manager.ITemplateDCManager;
import de.actonic.gdpr.shared.newDC.model.template.ActionDCModel;
import de.actonic.gdpr.shared.newDC.model.template.ConditionDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TemplateDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TemplateScopeDCModel;
import de.actonic.gdpr.shared.newDC.model.template.TriggerDCModel;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class TemplateDCManager
implements ITemplateDCManager {
    private final TemplateDCDao templateDao;

    public TemplateDCManager(TemplateDCDao templateDao) {
        this.templateDao = templateDao;
    }

    public TemplateDCModel entityToModel(TemplateDCEntity entity) {
        return TemplateDCModel.builder().id(Integer.valueOf(entity.getID())).name(entity.getName()).skipScanned(entity.getSkipScanned()).enabled(entity.getEnabled()).fields((List)GDPRJsonUtils.fromJson((String)entity.getFields(), (Type)GDPRJsonUtils.LIST_STRING_TYPE)).creator(entity.getCreator()).creationDate(entity.getCreationDate()).lastModifier(entity.getLastModifier()).lastModificationDate(entity.getModificationDate()).triggerType(entity.getTriggerType()).scopeType((TemplateScopeDCModel)GDPRJsonUtils.fromJson((String)entity.getScopeType(), TemplateScopeDCModel.class)).trigger((TriggerDCModel)GDPRJsonUtils.fromJson((String)entity.getTrigger(), TriggerDCModel.class)).actions((List)GDPRJsonUtils.fromJson((String)entity.getActions(), (Type)GDPRJsonUtils.getListObjectType(ActionDCModel.class))).conditions((List)GDPRJsonUtils.fromJson((String)entity.getConditions(), (Type)GDPRJsonUtils.getListObjectType(ConditionDCModel.class))).version(entity.getVersion()).templateType(entity.getTemplateType()).parentId(entity.getParentId()).contributors((Set)GDPRJsonUtils.fromJson((String)entity.getContributors(), (Type)GDPRJsonUtils.HASH_SET_STRING_TYPE)).comment(entity.getComment()).build();
    }

    public List<TemplateDCModel> entitiesToModels(List<TemplateDCEntity> entities) {
        return entities.stream().map(this::entityToModel).collect(Collectors.toList());
    }

    public void getAllInStream(IGDPRStreamExportManager streamExportManager, TemplateDCModel template) {
        this.templateDao.getAllInStream(streamExportManager, template);
    }

    public List<TemplateDCModel> getFilteredTemplates(String name, Boolean isEnabled, String ... templateTypes) {
        return null;
    }

    public TemplateDCModel getTemplateById(Integer templateId) {
        TemplateDCEntity entity = this.templateDao.getTemplateById(templateId);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(this.templateDao.getTemplateById(templateId));
    }

    public TemplateDCModel createSimpleTemplate(TemplateDCModel template) {
        TemplateDCEntity entity = this.templateDao.createSimpleTemplate(template.getTemplateType(), template.getCreator(), template.getContributors(), template.getVersion(), template.getEnabled());
        return this.entityToModel(entity);
    }

    public TemplateDCModel getDraftTemplate(Integer parentId) {
        TemplateDCEntity[] entities = this.templateDao.getDraftTemplate(parentId);
        if (entities == null || entities.length == 0) {
            return null;
        }
        return this.entityToModel(entities[0]);
    }

    public TemplateDCModel updateTemplate(TemplateDCModel template, boolean isFullUpdate) {
        TemplateDCEntity entity = this.templateDao.updateTemplate(isFullUpdate, template.getId(), template.getName(), template.getSkipScanned(), template.getEnabled(), template.getFields(), template.getCreator(), template.getLastModifier(), template.getCreationDate(), template.getTriggerType(), template.getTrigger(), template.getScopeType(), template.getConditions(), template.getActions(), template.getVersion(), template.getTemplateType(), template.getParentId(), template.getContributors(), template.getComment());
        return this.entityToModel(entity);
    }

    public void deleteTemplate(Integer templateId) {
        this.templateDao.deleteTemplate(templateId);
    }

    public TemplateDCModel createDraftTemplate(TemplateDCModel template) {
        TemplateDCEntity entity = this.templateDao.createTemplateDraft(template.getName(), template.getSkipScanned(), template.getEnabled(), template.getFields(), template.getCreator(), template.getTriggerType(), template.getScopeType(), template.getTrigger(), template.getActions(), template.getConditions(), template.getVersion(), template.getTemplateType(), template.getParentId(), template.getContributors());
        return this.entityToModel(entity);
    }

    public TemplateDCModel updateContributors(Integer id, Set<String> contributors) {
        return this.entityToModel(this.templateDao.updateContributors(id, contributors));
    }

    public TemplateDCModel restoreTemplate(TemplateDCModel template) {
        return this.entityToModel(this.templateDao.updateTemplate(template.getId(), template.getTemplateType(), template.getLastModifier()));
    }

    public List<TemplateDCModel> getTemplatesByTypes(String ... types) {
        return this.entitiesToModels(this.templateDao.getTemplateByTypes(Lists.newArrayList((Object[])types)));
    }

    public TemplateDCModel updateActions(TemplateDCModel template) {
        TemplateDCEntity entity = this.templateDao.updateActions(template.getId(), template.getLastModifier(), template.getContributors(), template.getActions());
        return this.entityToModel(entity);
    }

    public TemplateDCModel updateConditions(TemplateDCModel template) {
        TemplateDCEntity entity = this.templateDao.updateConditions(template.getId(), template.getLastModifier(), template.getContributors(), template.getConditions());
        return this.entityToModel(entity);
    }

    public List<TemplateDCModel> getFilteredTemplates(Boolean isEnabled, String ... triggerTypes) {
        return this.entitiesToModels(this.templateDao.getFilteredTemplates(isEnabled, Lists.newArrayList((Object[])triggerTypes)));
    }
}

