/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.scheduling;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import de.actonic.confluence.gdpr.component.service.DataRuleService;
import de.actonic.confluence.gdpr.scheduling.DataLevelRulesJob;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DataLevelRulesJobStarter
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(DataLevelRulesJobStarter.class);
    private static final String JOB_NAME = DataLevelRulesJob.class.getName() + ":job";
    private final DataRuleService dataRuleService;
    @ComponentImport
    private final PluginScheduler pluginScheduler;
    private final long interval = 60000L;

    @Autowired
    public DataLevelRulesJobStarter(PluginScheduler pluginScheduler, DataRuleService dataRuleService) {
        this.pluginScheduler = pluginScheduler;
        this.dataRuleService = dataRuleService;
    }

    public void onStart() {
        this.reschedule();
    }

    @PreDestroy
    public void onStop() {
        this.pluginScheduler.unscheduleJob(JOB_NAME);
    }

    public void reschedule() {
        this.pluginScheduler.scheduleJob(JOB_NAME, DataLevelRulesJob.class, (Map)new HashMap<String, Object>(){
            {
                this.put("dataRuleService", DataLevelRulesJobStarter.this.dataRuleService);
            }
        }, new Date(), 60000L);
    }
}

