define("actonic-gdpr/announcing/groundwork", ["jquery", "actonic-gdpr/announcing/rest", "actonic-gdpr/core/flags"], function ($, Rest, flags) {

    function Groundwork() {
        this.init = function () {
            getAnnouncingItems();
        }

        function getAnnouncingItems() {
            $("#progress-bar").show();
            Rest.getAnnouncingItems(
                function (data) { // success
                    $("#progress-bar").hide();
                    //log.debug("Rest.getAnnouncingItems data = " + JSON.stringify(data));
                    eventmachine.callEvent("announcing/items-received", data);
                },
                function (error) { // error
                    $("#progress-bar").hide();
                    flags.showFlag(AJS.I18n.getText("js-announcing.groundwork.error.title"),  AJS.I18n.getText("js-announcing.groundwork.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }
    }

    return new Groundwork();
});