/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class GDPRAbstractEntityDao {
    protected ActiveObjects ao;

    public GDPRAbstractEntityDao(ActiveObjects ao) {
        this.ao = ao;
    }

    protected <T extends RawEntity<K>, K> T getFirstByField(Class<T> type, String field, Object value) {
        if (value == null) {
            return null;
        }
        RawEntity[] result = this.ao.find(type, Query.select().where(field + " = ?", new Object[]{value}).order("ID ASC"));
        if (result.length > 0) {
            return (T)result[0];
        }
        return null;
    }

    protected <T extends RawEntity<K>, K> T getLastByField(Class<T> type, String field, Object value) {
        if (value == null) {
            return null;
        }
        RawEntity[] result = this.ao.find(type, Query.select().where(field + " = ?", new Object[]{value}).order("ID ASC"));
        if (result.length > 0) {
            return (T)result[result.length - 1];
        }
        return null;
    }

    protected <T extends RawEntity<K>, K> T getFirstByQuery(Class<T> type, Query query) {
        if (query == null) {
            return null;
        }
        RawEntity[] result = this.ao.find(type, query);
        if (result.length > 0) {
            return (T)result[0];
        }
        return null;
    }

    protected <T extends RawEntity<K>, K> T getLastByQuery(Class<T> type, Query query) {
        if (query == null) {
            return null;
        }
        RawEntity[] result = this.ao.find(type, query);
        if (result.length > 0) {
            return (T)result[result.length - 1];
        }
        return null;
    }

    public static <V> void setIfNotNull(V value, Consumer<V> setter) {
        if (Objects.nonNull(value)) {
            setter.accept(value);
        }
    }

    public static <V> void setDate(Boolean showInPeriod, V value, Consumer<V> setter) {
        if (showInPeriod == null) {
            return;
        }
        if (showInPeriod.booleanValue()) {
            setter.accept(value);
        } else {
            setter.accept(null);
        }
    }

    public static String createWhereClause(Collection<?> collection, String delimiter, String prefix, String suffix) {
        return collection.stream().map(id -> "?").collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static void appendDelimiter(StringBuilder sb, String value) {
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
        sb.append(value);
    }
}

