/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.scheduling;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.actonic.gdpr.announcement.scheduling.CleanAnnouncementRecycleBinJob;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
@ExportAsService(value={LifecycleAware.class})
public class CleanAnnouncementRecycleBinJobStarter
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(CleanAnnouncementRecycleBinJobStarter.class);
    private final JobRunnerKey SCHEDULED_JOB_KEY = JobRunnerKey.of((String)CleanAnnouncementRecycleBinJob.class.getName());
    @ComponentImport
    private final SchedulerService schedulerService;
    private final CleanAnnouncementRecycleBinJob jobRunner;
    private static final long INTERVAL = 86400000L;
    private static final int MIN_DELAY = 15000;

    public CleanAnnouncementRecycleBinJobStarter(SchedulerService schedulerService, CleanAnnouncementRecycleBinJob jobRunner) {
        this.schedulerService = schedulerService;
        this.jobRunner = jobRunner;
    }

    public void onStart() {
        log.info("starting onStart");
        this.schedulerService.registerJobRunner(this.SCHEDULED_JOB_KEY, (JobRunner)this.jobRunner);
        try {
            Date firstRun = new Date(System.currentTimeMillis() + 15000L);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)this.SCHEDULED_JOB_KEY).withSchedule(Schedule.forInterval((long)86400000L, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            log.info("Schedule created");
        }
        catch (Exception e) {
            log.info("There was a problem in creating the schedule");
        }
        log.info("finished onStart");
    }

    public void onStop() {
        log.info("starting onStop");
        List jobs = this.schedulerService.getJobsByJobRunnerKey(this.SCHEDULED_JOB_KEY);
        jobs.forEach(job -> this.schedulerService.unscheduleJob(job.getJobId()));
        this.schedulerService.unregisterJobRunner(this.SCHEDULED_JOB_KEY);
        log.info("finished onStop");
    }
}

